% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExpectedSecondStageInformation.R
\name{getExpectedSecondStageInformation}
\alias{getExpectedSecondStageInformation}
\title{Calculate Expected Second-stage Information}
\usage{
getExpectedSecondStageInformation(
  design,
  likelihoodRatioDistribution = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}

\item{likelihoodRatioDistribution}{The distribution to be used for the effect size of the likelihood ratio in the calculation of the expected second-stage information. Options are \code{"fixed", "normal", "exp", "unif", "maxlr"} for fixed effect size, normally distributed, exponentially distributed, uniformly distributed prior of the effect size and maximum likelihood ratio, respectively.
Each case requires different additional specifications: \cr
\itemize{
\item \code{likelihoodRatioDistribution="fixed"} uses one (or more) fixed effect sizes for the likelihood ratio and requires the parameter \code{deltaLR} which provides the mean difference under which to calculate the likelihood ratio. If \code{deltaLR} contains multiple values, they may be weighted using an additional argument \code{weightsDeltaLR}. Omitting \code{weightsDeltaLR} automatically leads to equal weighting.
\item \code{likelihoodRatioDistribution="normal"} uses a normal prior for the effect size and requires parameters \code{deltaLR} and \code{tauLR} for the mean and standard deviation of the normal distribution (both on mean difference scale).
\item \code{likelihoodRatioDistribution="exp"} uses an exponential prior for the effect size and requires the parameter \code{kappaLR} which is the mean of the exponential distribution (on the mean difference scale).
\item \code{likelihoodRatioDistribution="unif"} uses a uniform prior for the effect size and requires the specification of \code{deltaMaxLR}, which is the maximum of the support for the uniform likelihood ratio distribution (on the mean difference scale).
\item \code{likelihoodRatioDistribution="maxlr"} estimates the non-centrality parameter to be used for the likelihood ratio from the data. No additional parameters must be specified.
}
The default is \code{likelihoodRatioDistribution=NULL}.
In this case, the likelihood ratio distribution under which the expected second-stage information is calculated is taken directly from the design object.}

\item{...}{{Additional parameters required for the specification of \code{likelihoodRatioDistribution}}.}
}
\value{
Expected second-stage information.
}
\description{
Calculate the expected second-stage information using the optimal conditional error function with specific assumptions.
}
\details{
{The expected second-stage information is calculated as:
\deqn{\mathbb{E}(I_{2})=\int_{\alpha_1}^{\alpha_0}\frac{\nu(\alpha_2(p_1)) \cdot l(p_1)}{\Delta_1^2} dp_1,}
where
\itemize{
\item \eqn{\alpha_1, \alpha_0} are the first-stage efficacy and futility boundaries
\item \eqn{\alpha_2(p_1)} is the optimal conditional error calculated for \eqn{p_1}
\item \eqn{l(p_1)} is the "true" likelihood ratio under which to calculate the expected sample size. This can be different from the likelihood ratio used to calibrate the optimal conditional error function.
\item \eqn{\Delta_1} is the assumed treatment effect to power for, expressed as a mean difference. It may depend on the interim data (i.e., \eqn{p_1}) in case \code{useInterimEstimate = TRUE} was specified for the design object.
\item \eqn{\nu(\alpha_2(p_1)) = (\Phi^{-1}(1-\alpha_2(p_1))+\Phi^{-1}(CP))^2} is a factor calculated for the specific assumptions about the optimal conditional error function and the target conditional power \eqn{CP}.
}}
}
\examples{
# Get a design
design <- getDesignOptimalConditionalErrorFunction(
alpha = 0.025, alpha1 = 0.001, alpha0 = 0.5, conditionalPower = 0.9,
delta1 = 0.25, likelihoodRatioDistribution = "fixed", deltaLR = 0.25,
firstStageInformation = 80, useInterimEstimate = FALSE,
)
# Calculate expected information under correct specification
getExpectedSecondStageInformation(design)

# Calculate expected information under the null hypothesis
getExpectedSecondStageInformation(
 design = design, likelihoodRatioDistribution = "fixed", deltaLR = 0
)

}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393
}
\seealso{
\code{\link[=getDesignOptimalConditionalErrorFunction]{getDesignOptimalConditionalErrorFunction()}}, \code{\link[=getSecondStageInformation]{getSecondStageInformation()}}
}
