% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.set_method}
\alias{dsadmin.set_method}
\title{Set DataSHIELD method}
\usage{
dsadmin.set_method(
  opal,
  name,
  func = NULL,
  path = NULL,
  type = "aggregate",
  profile = NULL
)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{name}{Name of the method, as it will be accessed by DataSHIELD users.}

\item{func}{Function name or function code.}

\item{path}{Path to the R file containing the script (mutually exclusive with func).}

\item{type}{Type of the method: "aggregate" (default) or "assign"}

\item{profile}{The DataSHIELD profile name to which operation applies. See also \link{dsadmin.profiles}.}
}
\description{
Set DataSHIELD method
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# as a package's function
dsadmin.set_method(o, 'foo', func = 'base::mean')
# as a custom function
dsadmin.set_method(o, 'foo', func = function(x) { base::mean(x) })
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_github_package}()},
\code{\link{dsadmin.install_local_package}()},
\code{\link{dsadmin.install_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_description}()},
\code{\link{dsadmin.package_descriptions}()},
\code{\link{dsadmin.publish_package}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_options}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()},
\code{\link{dsadmin.unpublish_package}()}
}
\concept{DataSHIELD functions}
