% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview_template.R
\name{preview_template}
\alias{preview_template}
\title{Generate Report Previewing the Locations From Mapping File}
\usage{
preview_template(obnd, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
onbrand object with template previews added and any messages passed
along
}
\description{
Takes an onbrand object with a loaded template and populates
the template with the elements from the mapping file.
}
\examples{
obnd = read_template(
   template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
   mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))
obnd = preview_template(obnd)

obnd = read_template(
   template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
   mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))
obnd = preview_template(obnd)
}
