% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_teams.R
\name{nhl_teams}
\alias{nhl_teams}
\title{Retrieve metadata on NHL teams from the API}
\usage{
nhl_teams(teamIds = NULL, params = NULL)
}
\arguments{
\item{teamIds}{\code{integer()}, ids of the teams or \code{NULL} (default)
for all teams. As of end of 2019, the valid team ids seem to be
in the \code{1:54} range.}

\item{params}{\verb{named list()}, further parameters passed to
\code{nhl_url_teams}.}
}
\value{
\code{data.frame}, with data on teams, one row per team.
}
\description{
Retrieves team metadata such as the teams names,
abbreviations, locations, conferences, venues, etc.
}
\details{
The API allows to retrieve data on all teams at once,
which is achieved by the default \code{NULL} value for the team id.
}
\examples{
\dontrun{
  nhl_teams()
  nhl_teams(1:3)
}

}
