% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{diag_expand}
\alias{diag_expand}
\alias{diag_expand.list}
\alias{diag_expand.diffnet}
\alias{diag_expand.matrix}
\alias{diag_expand.array}
\alias{diag_expand.dgCMatrix}
\title{Creates a square matrix suitable for spatial statistics models.}
\usage{
diag_expand(...)

\method{diag_expand}{list}(graph, self = is_self(graph), valued = is_valued(graph), ...)

\method{diag_expand}{diffnet}(graph, self = is_self(graph), valued = is_valued(graph), ...)

\method{diag_expand}{matrix}(graph, nper, self = is_self(graph), valued = is_valued(graph), ...)

\method{diag_expand}{array}(graph, self = is_self(graph), valued = is_valued(graph), ...)

\method{diag_expand}{dgCMatrix}(graph, nper, self = is_self(graph), valued = is_valued(graph), ...)
}
\arguments{
\item{...}{Further arguments to be passed to the method.}

\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{self}{Logical scalar. When \code{TRUE} autolinks (loops, self edges) are allowed (see details).}

\item{valued}{Logical scalar. When \code{TRUE} weights will be considered. Otherwise non-zero values will be replaced by ones.}

\item{nper}{Integer scalar. Number of time periods of the graph.}
}
\value{
A square matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} of
size \code{(nnode(g)*nper)^2}
}
\description{
Creates a square matrix suitable for spatial statistics models.
}
\examples{
# Simple example ------------------------------------------------------------
set.seed(23)
g <- rgraph_er(n=10, p=.5, t=2,undirected=TRUE)

# What we've done: A list with 2 bernoulli graphs
g

# Expanding to a 20*20 matrix with structural zeros on the diagonal
# and on cell 'off' adjacency matrix
diag_expand(g)
}
