% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publications.R
\name{get_publications.publication}
\alias{get_publications.publication}
\title{Update information for a publications object.}
\usage{
\method{get_publications}{publication}(x, ...)
}
\arguments{
\item{x}{integer A publication}

\item{...}{\code{publicationid}
The unique numeric identifier associated with a publication in Neotoma.
\code{datasetid}
A unique identifier for a Neotoma dataset that is associated
with a publication.
\code{familyname} The full or partial last name for an individual author.
\code{pubtype} The publication type, from \code{get_tables("publicationtypes")}.
\code{year} The year the publication was released.
\code{search} A plain text search string used to search the citation.}
}
\value{
updated \code{publication} object
}
\description{
This works for records without publicationids. We assume that
data with publicationids is correct.
}
\examples{
\donttest{
# Take a publication object and purposely degrade the metadata:
bad_pub <- get_publications(666)
# Note this only changes the reported year, not the citation string.
bad_pub[[1]]@year <- "1923"
bad_pub[[1]]@publicationid <- NA_integer_
updated_pubs <- get_publications(bad_pub[[1]])
attr(updated_pubs, "matches")
# we see the proper citation in the record:
updated_pubs <- attr(updated_pubs, "matches")[[3]]
}
}
