% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ineqsym.R
\name{ineqsym}
\alias{ineqsym}
\title{Symmetries of hyperplane arrangements define equivalent scales}
\usage{
ineqsym(set, a = 1, b = 0, involution = FALSE, edo = 12)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{a}{Integer: controls permutations of generic intervals. Must be
coprime to the size of the set. Defaults to \code{1}.}

\item{b}{Integer: controls modal rotation. Defaults to \code{0}.}

\item{involution}{Boolean: controls involutional symmetry. Defaults to
\code{FALSE}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector representing a scale of same length as \code{set}.
Default parameters determine the identity symmetry and will return
\code{set} itself.
}
\description{
Produces scales of different colors which have equivalent scalar properties.
The hyperplane arrangements of MCT have three types of symmetry, which allows
us to find scales at different but equivalent points in the arrangement.
Such scales will be nearly structurally identical in most senses although
their specific intervals will be rather different. See details for a discussion
of the symmetries involved.
}
\details{
Two symmetries of the MCT hyperplane arrangement are familiar.
One is modal "rotation":
two modes of the same scale must have equivalent structures, by the
defining relations of the theory. The parameter \code{b} controls these rotations.
The second familiar symmetry is \emph{involution} (see "Modal Color Theory," 32).
Set parameter \code{involution} to TRUE to apply this symmetry. The more
interesting symmetry of the MCT arrangements is controlled by parameter \code{a}.
This symmetry allows us to permute the roles of the scale's generic intervals
in its scalar makeup. For instance, non-degenerate well-formed scales (see
\code{\link[=iswellformed]{iswellformed()}} are all generated by a particular generic interval. The
familiar diatonic scale is generated by its generic fourths, whereas
another well-formed scale like (0, 2, 3, 5, 6, 7, 9) in 10edo (with step-word
LSLSSLS) is generated by its generic sixths. We can permute the hyperplanes
of the heptachordal MCT arrangement so that the overall structure is
preserved but the diatonic scale is mapped onto LSLSSLS. In general, the
permutations of \code{ineqsym()} allow us to map any non-degenerate well-formed
scale onto any other: they form an orbit under the symmetries of the space.
This gives another sense in which "well-formedness" is a large family
of scale structures. That sense generalizes to \emph{all} scales, not just ones
that are highly regular like well-formed scales.

In short, \code{ineqsym()} preserves many scalar properties, including:
\itemize{
\item \code{\link[=countsvzeroes]{countsvzeroes()}} and \code{\link[=svzero_fingerprint]{svzero_fingerprint()}}
\item \code{\link[=howfree]{howfree()}}
\item \code{\link[=ratio]{ratio()}}, \code{\link[=delta]{delta()}}, and \code{\link[=eps]{eps()}}
\item \code{\link[=brightnessgraph]{brightnessgraph()}} structure
\item \code{\link[=evenness]{evenness()}}
\item \code{\link[=isgwf]{isgwf()}} and \emph{a fortiori} \code{\link[=iswellformed]{iswellformed()}}
\item Number and respective properties of adjacent colors
\item \code{\link[=spectrumcount]{spectrumcount()}} up to permutation of the values
}
}
\examples{
wt_plus_1 <- sc(7,33)
equiv_scale <- ineqsym(wt_plus_1, 3, 2)
both_scales <- cbind(wt_plus_1, equiv_scale)
freedoms <- apply(both_scales, 2, howfree)
evennesses <- round(apply(both_scales, 2, evenness), 3)
svzeroes <- apply(both_scales, 2, countsvzeroes)
ratios <- round(apply(both_scales, 2, ratio), 3)
spectra <- apply(apply(both_scales, 2, spectrumcount), 2, toString)
cbind(freedoms, evennesses, svzeroes, ratios, spectra)
brightnessgraph(wt_plus_1)
brightnessgraph(equiv_scale)

}
