% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_shared_with_me_shares}
\alias{list_shared_with_me_shares}
\title{List all shares shared with the current user}
\usage{
list_shared_with_me_shares(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A tibble containing one row per shared object, with columns describing
the owner, object type, object name, and granted privileges.
}
\description{
Retrieves all database objects that have been shared with the current
authenticated user in MotherDuck.
}
\details{
This function queries the \code{MD_INFORMATION_SCHEMA.SHARED_WITH_ME} view to
return metadata about all shares granted to the current user, including
the owner, object name, type, and privileges.
The result is returned as a tidy tibble for easy manipulation in R.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
shared_tbl <- list_shared_with_me_shares(con)
print(shared_tbl)
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
