% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mir_vec.R
\name{get_mir}
\alias{get_mir}
\title{Get miRNA names from a data frame}
\usage{
get_mir(
  df,
  top = NULL,
  threshold = NULL,
  topic = NULL,
  col.mir = miRNA,
  col.pmid = PMID,
  col.topic = Topic
)
}
\arguments{
\item{df}{Data frame containing miRNA names. If \code{threshold} is set,
\code{df} must also contain PubMed-IDs. If \code{topic} is set, \code{df} must also contain
topic names.}

\item{top}{Integer. Optional. Specifies number of most frequent miRNA names
to return. If neither \code{top} nor \code{threshold} is set, \code{top} is automatically set
to \code{5}.}

\item{threshold}{Integer or float. Optional. If \code{threshold} >= 1, return
miRNA names mentioned in at least \code{threshold} abstracts.
If \code{threshold} is between 0 and 1, return miRNA names mentioned
in at least \code{threshold} abstracts of all abstracts in \code{df}.}

\item{topic}{String. Optional. Character vector specifying which topics to obtain
miRNA names from.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{col.topic}{Symbol. Column containing topic names.}
}
\value{
Character vector containing miRNA names.
}
\description{
Get miRNA names from a data frame. These miRNA names can either be the most
frequent ones, or the ones exceeding a threshold.
}
\details{
Get miRNA names from a data frame. These miRNA names can either be the most
frequent ones, or the ones exceeding a threshold. Furthermore, if the data
frame contains abstracts of different topics, only the miRNA names of
specific topics can be obtained by setting the \code{topic} argument.
\itemize{
\item To get the most frequent miRNA names, set the \code{top} argument. \code{top}
determines how many most frequent miRNA names are returned, according to their
rank. Ties among the most
frequently mentioned miRNAs are treated as
the same rank, e.g. if \emph{miR-126}, \emph{miR-34}, and \emph{miR-29} were all mentioned
the most often with the same frequency, they would all be returned by
specifying \code{top = 1}, \code{top = 2}, and \code{top = 3}.
\item To get the miRNA names exceeding a threshold, set the \code{threshold} argument.
\code{threshold} can either be an absolute value, e.g. 3, or a float between 0 and 1,
e.g. 0.2.
If \code{threshold} is an absolute value, \code{get_mir()} returns only the miRNA names
mentioned in at least \code{threshold} abstracts.
If \code{threshold} is a float between 0 and 1, \code{get_mir()} returns
only miRNA names mentioned in at least \code{threshold} abstracts
of all abstracts. \code{threshold} requires the data frame to have a column with
PubMed IDs.
}

If neither \code{top} nor \code{threshold} is set, \code{top} is automatically set to \code{5}.
}
\seealso{
Other get functions: 
\code{\link{get_distinct_mir_df}()},
\code{\link{get_distinct_mir_vec}()},
\code{\link{get_pmid}()},
\code{\link{get_shared_mir_df}()},
\code{\link{get_shared_mir_vec}()},
\code{\link{get_snp}()}
}
\concept{get functions}
