% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{pp.ll}
\alias{pp.ll}
\title{Log-likelihood of Poisson process of threshold exceedances}
\usage{
pp.ll(par, dat, u, np = 1)
}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{u}{threshold}

\item{np}{number of periods of observations. This is a \emph{post hoc} adjustment for the intensity so that the parameters of the model coincide with those of a generalized extreme value distribution with block size \code{length(dat)/np}.}
}
\value{
log-likelihood of the NHPP
}
\description{
This function returns the log-likelihood of the non-homogeneous Poisson process
of exceedances above threshold \code{u}, adjusted so that there are \code{np} periods
of observations.
}
\seealso{
\code{\link{pp}}
}
\keyword{internal}
