% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penultimate.R
\name{fit.egp}
\alias{fit.egp}
\alias{tstab.egp}
\title{Parameter stability plot and maximum likelihood routine for extended GP models}
\usage{
fit.egp(xdat, thresh, model = c("egp1", "egp2", "egp3"), init, show = FALSE)

tstab.egp(
  xdat,
  thresh,
  model = c("egp1", "egp2", "egp3"),
  plots = 1:3,
  umin,
  umax,
  nint,
  changepar = TRUE,
  ...
)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{model}{a string indicating which extended family to fit}

\item{init}{vector of initial values, with \eqn{\log(\kappa)}{log(\kappa)} and \eqn{\log(\sigma)}{log(\sigma)}; can be omitted.}

\item{show}{logical; if \code{TRUE}, print the results of the optimization}

\item{plots}{vector of integers specifying which parameter stability to plot (if any); passing \code{NA} results in no plots}

\item{umin}{optional minimum value considered for threshold (if \code{thresh} is not provided)}

\item{umax}{optional maximum value considered for threshold (if \code{thresh} is not provided)}

\item{nint}{optional integer number specifying the number of thresholds to test.}

\item{changepar}{logical; if \code{TRUE}, the graphical parameters (via a call to \code{par}) are modified.}

\item{...}{additional arguments for the plot function, currently ignored}
}
\value{
\code{fit.egp} outputs the list returned by \link[stats]{optim}, which contains the parameter values, the hessian and in addition the standard errors

\code{tstab.egp} returns a plot(s) of the parameters fit over the range of provided thresholds, with pointwise normal confidence intervals; the function also returns an invisible list containing notably the matrix of point estimates (\code{par}) and standard errors (\code{se}).
}
\description{
The function \code{tstab.egp} provides classical threshold stability plot for (\eqn{\kappa}, \eqn{\sigma}, \eqn{\xi}).
The fitted parameter values are displayed with pointwise normal 95\% confidence intervals.
The function returns an invisible list with parameter estimates and standard errors, and p-values for the Wald test that \eqn{\kappa=1}.
 The plot is for the modified scale (as in the generalised Pareto model) and as such it is possible that the modified scale be negative.
\code{tstab.egp} can also be used to fit the model to multiple thresholds.
}
\details{
\code{fit.egp} is a numerical optimization routine to fit the extended generalised Pareto models of Papastathopoulos and Tawn (2013),
using maximum likelihood estimation.
}
\examples{
xdat <- mev::rgp(
  n = 100,
  loc = 0,
  scale = 1,
  shape = 0.5)
fitted <- fit.egp(
  xdat = xdat,
  thresh = 1,
  model = "egp2",
  show = TRUE)
thresh <- mev::qgp(seq(0.1, 0.5, by = 0.05), 0, 1, 0.5)
tstab.egp(
   xdat = xdat,
   thresh = thresh,
   model = "egp2",
   plots = 1:3)
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143.
}
\author{
Leo Belzile
}
