% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_all_modules.R
\name{process_all_modules}
\alias{process_all_modules}
\title{Process All Modules in Pathway Information}
\usage{
process_all_modules(
  pathway_infor,
  Sample_KO,
  plus_scale_method,
  comma_scale_method,
  verbose = TRUE
)
}
\arguments{
\item{pathway_infor}{Data frame containing pathway information, see examples.}

\item{Sample_KO}{Data frame containing KO (KEGG Orthology) sample data}

\item{plus_scale_method}{Scaling method for plus-separated KOs ("mean", "min", or "max")}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}

\item{verbose}{Logical controlling console output:
\itemize{
\item \code{TRUE} (default): Print progress messages
\item \code{FALSE}: Silent mode
}}
}
\value{
A list with two components:
\itemize{
\item \code{data}: A data frame of processed results for all modules, with unique rows to avoid duplicates.
\item \code{log}: A character vector of timestamped log messages.
}
}
\description{
Processes all metabolic modules in pathway information, handling each module's structure,
definition, and bracket components. Aggregates results across all modules.
}
