% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_nodes.R
\name{mark_nodes}
\alias{mark_nodes}
\alias{node_is_isolate}
\alias{node_is_pendant}
\alias{node_is_independent}
\alias{node_is_cutpoint}
\alias{node_is_fold}
\alias{node_is_mentor}
\alias{node_is_neighbor}
\title{Marking nodes based on structural properties}
\usage{
node_is_isolate(.data)

node_is_pendant(.data)

node_is_independent(.data)

node_is_cutpoint(.data)

node_is_fold(.data)

node_is_mentor(.data, elites = 0.1)

node_is_neighbor(.data, node)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{elites}{The proportion of nodes to be selected as mentors.
By default this is set at 0.1.
This means that the top 10\% of nodes in terms of degree,
or those equal to the highest rank degree in the network,
whichever is the higher, will be used to select the mentors.

Note that if nodes are equidistant from two mentors,
they will choose one at random.
If a node is without a path to a mentor,
for example because they are an isolate,
a tie to themselves (a loop) will be created instead.
Note that this is a different default behaviour than that
described in Valente and Davis (1999).}

\item{node}{Name or index of node.}
}
\description{
These functions return logical vectors the length of the
nodes in a network identifying which hold certain properties or positions in the network.
\itemize{
\item \code{node_is_isolate()} marks nodes that are isolates,
with neither incoming nor outgoing ties.
\item \code{node_is_independent()} marks nodes that are members of the largest independent set,
aka largest internally stable set.
\item \code{node_is_cutpoint()} marks nodes that cut or act as articulation points in a network,
increasing the number of connected components when removed.
\item \code{node_is_core()} marks nodes that are members of the network's core.
\item \code{node_is_fold()} marks nodes that are in a structural fold between two or more
triangles that are only connected by that node.
\item \code{node_is_mentor()} marks a proportion of high indegree nodes as 'mentors' (see details).
}
}
\examples{
node_is_isolate(ison_brandes)
node_is_independent(ison_adolescents)
node_is_cutpoint(ison_brandes)
node_is_fold(create_explicit(A-B, B-C, A-C, C-D, C-E, D-E))
}
\references{
\subsection{On independent sets}{

Tsukiyama, Shuji, Mikio Ide, Hiromu Ariyoshi, and Isao Shirawaka. 1977.
"A new algorithm for generating all the maximal independent sets".
\emph{SIAM Journal on Computing}, 6(3):505–517.
\doi{10.1137/0206036}
}

\subsection{On articulation or cut-points}{

Tarjan, Robert E. and Uzi Vishkin. 1985.
"An Efficient Parallel Biconnectivity Algorithm",
\emph{SIAM Journal on Computing} 14(4): 862-874.
\doi{10.1137/0214061}
}

\subsection{On structural folds}{

Vedres, Balazs, and David Stark. 2010.
"Structural folds: Generative disruption in overlapping groups",
\emph{American Journal of Sociology} 115(4): 1150-1190.
\doi{10.1086/649497}
}

\subsection{On mentoring}{

Valente, Thomas, and Rebecca Davis. 1999.
"Accelerating the Diffusion of Innovations Using Opinion Leaders",
\emph{Annals of the American Academy of Political and Social Science} 566: 56-67.
}
}
\seealso{
Other marks: 
\code{\link{mark_diff}},
\code{\link{mark_select}},
\code{\link{mark_tie_select}},
\code{\link{mark_ties}},
\code{\link{mark_triangles}}
}
\concept{marks}
