% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{mantis_report}
\alias{mantis_report}
\title{Create an interactive time series report from a data frame}
\usage{
mantis_report(
  df,
  file,
  inputspec,
  outputspec = NULL,
  alertspec = NULL,
  report_title = "mantis report",
  dataset_description = "",
  add_timestamp = FALSE,
  show_progress = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame containing multiple time series in long format. See
Details.}

\item{file}{String specifying the desired file name (and path) to save the
report to. The file name should include the extension ".html". If only a
file name is supplied, the report will be saved in the current working
directory. If a path is supplied, the directory should already exist. Any
existing file of the same name will be overwritten unless
\code{add_timestamp} is set to \code{TRUE}.}

\item{inputspec}{\code{\link[=inputspec]{inputspec()}} object specifying which columns in the
supplied \code{df} represent the "timepoint", "item", "value"  and (optionally)
"tab" for the time series. If a "tab" column is specified, a separate tab
will be created for each distinct value in the column.}

\item{outputspec}{\code{outputspec} object specifying the desired format of the
html table(s). If not supplied, default values will be used.}

\item{alertspec}{\code{\link[=alertspec]{alertspec()}} object specifying conditions to test and
display.}

\item{report_title}{Title to appear on the report.}

\item{dataset_description}{Short description of the dataset being shown. This
will appear on the report.}

\item{add_timestamp}{Append a timestamp to the end of the filename with
format \verb{_YYMMDD_HHMMSS}. This can be used to keep multiple versions of the
same report. Default = \code{FALSE}.}

\item{show_progress}{Print progress to console. Default = \code{TRUE}.}

\item{...}{Further parameters to be passed to \code{rmarkdown::render()}. Cannot
include any of \code{input}, \code{output_dir}, \code{output_file}, \code{params}, \code{quiet}.}
}
\value{
A string containing the name and full path of the saved report.
}
\description{
Accepts a data frame containing multiple time series in long format,
generates a collection of interactive time series plots for visual
inspection, and saves the report to disk.
}
\details{
The supplied data frame should contain multiple time series in long
format, i.e.:
\itemize{
\item one "timepoint" (date/posixt) column which will be used for the x-axes.
Values should follow a regular pattern, e.g. daily or monthly, but do not
have to be consecutive.
\item one or more "item" (character) columns containing categorical values
identifying distinct time series.
\item one "value" (numeric) column containing the time series values which will
be used for the y-axes.
\item Optionally, a "tab" (character) column containing categorical values which
will be used to group the time series into different tabs on the report.

The \code{inputspec} parameter maps the data frame columns to the above.
}
}
\examples{
\donttest{
# create an interactive report in the temp directory,
# with one tab per Location
filename <- mantis_report(
  df = example_prescription_numbers,
  file = file.path(tempdir(), "example_prescription_numbers_interactive.html"),
  inputspec = inputspec(
    timepoint_col = "PrescriptionDate",
    item_cols = c("Location", "Antibiotic", "Spectrum"),
    value_col = "NumberOfPrescriptions",
    tab_col = "Location",
    timepoint_unit = "day"
  ),
  outputspec = outputspec_interactive(),
  report_title = "Daily antibiotic prescribing",
  dataset_description = "Antibiotic prescriptions by site",
  show_progress = TRUE
)

filename
\dontshow{unlink(filename)}
}

\donttest{
# create an interactive report in the temp directory, with alerting rules
filename <- mantis_report(
  df = example_prescription_numbers,
  file = file.path(tempdir(), "example_prescription_numbers_interactive.html"),
  inputspec = inputspec(
    timepoint_col = "PrescriptionDate",
    item_cols = c("Location", "Antibiotic", "Spectrum"),
    value_col = "NumberOfPrescriptions",
    tab_col = "Location",
    timepoint_unit = "day"
  ),
  outputspec = outputspec_interactive(),
  alertspec = alertspec(
   alert_rules = alert_rules(
    alert_missing(extent_type = "any", extent_value = 1),
    alert_equals(extent_type = "all", rule_value = 0)
   ),
   show_tab_results = c("FAIL", "NA")
  ),
  report_title = "Daily antibiotic prescribing",
  dataset_description = "Antibiotic prescriptions by site",
  show_progress = TRUE
)

filename
\dontshow{unlink(filename)}
}

}
\seealso{
\code{\link[=inputspec]{inputspec()}}, \code{\link[=outputspec_interactive]{outputspec_interactive()}},
\code{\link[=outputspec_static_heatmap]{outputspec_static_heatmap()}}, \code{\link[=outputspec_static_multipanel]{outputspec_static_multipanel()}},
\code{\link[=alertspec]{alertspec()}}
}
