% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check_s3.R
\docType{class}
\name{ldmppr_model_check}
\alias{ldmppr_model_check}
\alias{print.ldmppr_model_check}
\alias{summary.ldmppr_model_check}
\alias{print.summary.ldmppr_model_check}
\alias{plot.ldmppr_model_check}
\title{Model fit diagnostic object}
\usage{
\method{print}{ldmppr_model_check}(x, ...)

\method{summary}{ldmppr_model_check}(object, ...)

\method{print}{summary.ldmppr_model_check}(x, ...)

\method{plot}{ldmppr_model_check}(x, which = c("combined", "L", "F", "G", "J", "E", "V"), ...)
}
\arguments{
\item{x}{an object of class `ldmppr_model_check`.}

\item{...}{additional arguments passed to the underlying `plot()` method (e.g., from **GET**).}

\item{object}{an object of class `ldmppr_model_check`.}

\item{which}{which envelope to plot. `"combined"` plots the global envelope; otherwise one of `"L"`, `"F"`, `"G"`, `"J"`, `"E"`, `"V"`.}
}
\value{
* `print()` prints a brief summary of the diagnostic object.
* `summary()` returns a `summary.ldmppr_model_check` object.
* `plot()` plots the combined envelope or a selected statistic envelope.
}
\description{
Objects of class `ldmppr_model_check` are returned by [check_model_fit()].
They contain global envelope test results and curve sets for multiple summary
functions/statistics.
}
\details{
An `ldmppr_model_check` is a list with components such as:
\itemize{
  \item `combined_env`: a global envelope test object (typically from **GET**)
  \item `envs`: named list of envelope test objects (e.g., `L`, `F`, `G`, `J`, `E`, `V`)
  \item `curve_sets`: named list of curve set objects
  \item `settings`: list of settings used when generating envelopes (e.g., `n_sim`, `thinning`)
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_model_check)}: Print a brief summary of the diagnostic results.

\item \code{summary(ldmppr_model_check)}: Summarize p-values from the combined and individual envelopes.

\item \code{plot(ldmppr_model_check)}: Plot the combined envelope or a selected statistic.

}}
\section{Functions}{
\itemize{
\item \code{print(summary.ldmppr_model_check)}: Print a summary produced by [summary.ldmppr_model_check()].

}}
