test_that("header and DLL API versions match", {
  Rcpp::cppFunction(
    code = '
      int later_dll_api_version() {
        int (*dll_api_version)() = (int (*)()) R_GetCCallable("later", "apiVersion");
        return (*dll_api_version)();
      }
    '
  )

  Rcpp::cppFunction(
    depends = 'later',
    includes = '
      #include <later_api.h>
    ',
    code = '
      int later_h_api_version() {
        return LATER_H_API_VERSION;
      }
    '
  )

  expect_identical(later_dll_api_version(), later_h_api_version())
})

test_that("logLevel works", {
  current <- later:::logLevel()
  expect_true(current %in% c("OFF", "ERROR", "WARN", "INFO", "DEBUG"))

  previous <- later:::logLevel("DEBUG")
  expect_equal(previous, current)
  expect_equal(later:::logLevel(), "DEBUG")

  expect_equal(later:::logLevel(current), "DEBUG")
  expect_equal(later:::logLevel(), current)
})
