% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamin_cli.R
\name{lamin_init}
\alias{lamin_init}
\alias{lamin_init_temp}
\title{Initialise LaminDB}
\usage{
lamin_init(storage, name = NULL, db = NULL, modules = NULL)

lamin_init_temp(
  name = "laminr-temp",
  db = NULL,
  modules = NULL,
  add_timestamp = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{storage}{A local directory, AWS S3 bucket or Google Cloud Storage bucket}

\item{name}{A name for the instance}

\item{db}{A Postgres database connection URL, use \code{NULL} for SQLite.}

\item{modules}{A vector of modules to include (e.g. "bionty")}

\item{add_timestamp}{Whether to append a timestamp to \code{name} to make it unique}

\item{envir}{An environment passed to \code{\link[withr:defer]{withr::defer()}}}
}
\description{
Initialise a new LaminDB instance
}
\details{
For \code{\link[=lamin_init_temp]{lamin_init_temp()}}, a time stamp is appended to \code{name} (if
\code{add_timestamp = TRUE}) and then a new instance is initialised with
\code{\link[=lamin_init]{lamin_init()}} using a temporary directory. A \code{\link[=lamin_delete]{lamin_delete()}} call is
registered as an exit handler with \code{\link[withr:defer]{withr::defer()}} to clean up the instance
when \code{envir} finishes.

The \code{\link[=lamin_init_temp]{lamin_init_temp()}} function is mostly for internal use and in most cases
users will want \code{\link[=lamin_init]{lamin_init()}}.
}
\examples{
\dontrun{
lamin_init("mydata", modules = c("bionty", "wetlab"))
}
}
