% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Color Difference}
\usage{
compare(x, metric = 2000, diag = FALSE, upper = FALSE)
}
\arguments{
\item{x}{A \code{\link{character}} vector of colors.}

\item{metric}{An \code{\link{integer}} value giving the year the metric was
recommended by the CIE. It must be one of "\code{1976}", "\code{1994}", or
"\code{2000}" (default; see \code{\link[spacesXYZ:DeltaE]{spacesXYZ::DeltaE()}}).}

\item{diag}{A \code{\link{logical}} scalar: should the diagonal of the distance matrix
be printed?}

\item{upper}{A \code{\link{logical}} scalar: should the upper triangle of the distance
matrix should be printed?}
}
\value{
A \link[stats:dist]{distance matrix}.
}
\description{
Computes CIELAB distance metric.
}
\examples{
if (requireNamespace("spacesXYZ", quietly = TRUE)) {
  ## Trichromat
  pal <- colour("bright")
  compare(pal(5))

  ## Deuteranopia
  deu <- change(pal, mode = "deuteranopia")
  compare(deu(5))

  ## Protanopia
  pro <- change(pal, mode = "protanopia")
  compare(pro(5))

  ## Tritanopia
  tri <- change(pal, mode = "tritanopia")
  compare(tri(5))

  ## Achromatopsia
  ach <- change(pal, mode = "achromatopsia")
  compare(ach(5))
}
}
\seealso{
Other diagnostic tools: 
\code{\link{change}()},
\code{\link{plot.color_scheme}()},
\code{\link{plot_map}()},
\code{\link{plot_scheme}()},
\code{\link{plot_scheme_colourblind}()},
\code{\link{plot_tiles}()}
}
\author{
N. Frerebeau
}
\concept{diagnostic tools}
