% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmp_functions.R
\name{cmp_post_fun}
\alias{cmp_post_fun}
\alias{cmp_split_fun}
\title{Split Function for Compliance Columns}
\usage{
cmp_post_fun(ret, spl, fulldf, .spl_context)

cmp_split_fun(df, spl, vals = NULL, labels = NULL, trim = FALSE, .spl_context)
}
\arguments{
\item{ret}{(\code{list})\cr result from previous split function steps.}

\item{spl}{(\code{split})\cr split object.}

\item{fulldf}{(\code{data.frame})\cr full data frame.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{vals}{(\code{character})\cr values to use for the split.}

\item{labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{trim}{(\code{logical})\cr whether to trim the values.}
}
\value{
a split function for use with \link[rtables:split_rows_by]{rtables::split_rows_by}
when creating proportion-based tables with compliance columns.
}
\description{
Here we just split into 3 columns for expected, received and missing visits.
}
\seealso{
\code{\link[rtables:make_split_fun]{rtables::make_split_fun()}} describing the requirements for this kind of
post-processing function.
}
