% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_eps.R
\name{save_eps}
\alias{save_eps}
\title{Save the chart in Eps format}
\usage{
save_eps(gplot, file.name, ...)
}
\arguments{
\item{gplot}{ggplot which will be saved.}

\item{file.name}{Character. Name of the file which will be generated}

\item{...}{Additional arguments to be passed to the \code{ggsave} function from the
\code{ggplot2} package.}
}
\value{
An \code{"eps"} file
}
\description{
Convenient function to save charts in Eps format.
}
\examples{
\donttest{
# Creating theme for ggplot2 graph using default arguments
library(ggplot2)
fig_raw <- ggplot() +
  geom_col(data = mtcars, aes(x = hp , y = mpg, fill = cyl)) +
  theme_ipea()
# Save ggplot output
save_eps(fig_raw,file.name = paste0(tempdir(),"/figura.eps"))
}
}
\seealso{
Other save: 
\code{\link{save_pdf}()}
}
\concept{save}
