% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateBasicData.R
\name{CreateBasicData}
\alias{CreateBasicData}
\title{CreateBasicData}
\usage{
CreateBasicData(..., diseasenet = NULL, biomarker = NULL)
}
\arguments{
\item{...}{Drug graph from \code{PrepareData}.}

\item{diseasenet}{A graph of Disease-related gene from \code{PrepareData}.}

\item{biomarker}{Character vector, the vector of Disease-related gene.}
}
\value{
A BasicData object.
}
\description{
Create BasicData Object
}
\examples{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
BasicData <- CreateBasicData(drug_herb, herb_compound, compound_target, diseasenet = disease)
}
\author{
Yuanlong Hu
}
