// (c) The HDF Group
#ifndef H5FLprivate_H
#define H5FLprivate_H
#if defined H5_NO_FREE_LISTS || defined H5_USING_MEMCHECKER
#define H5_NO_REG_FREE_LISTS
#define H5_NO_ARR_FREE_LISTS
#define H5_NO_SEQ_FREE_LISTS
#define H5_NO_BLK_FREE_LISTS
#define H5_NO_FAC_FREE_LISTS
#endif
typedef struct H5FL_reg_node_t {
    struct H5FL_reg_node_t *next;
} H5FL_reg_node_t;
typedef struct H5FL_reg_head_t {
    bool             init;
    unsigned         allocated;
    unsigned         onlist;
    const char      *name;
    size_t           size;
    H5FL_reg_node_t *list;
} H5FL_reg_head_t;
#define H5FL_REG_NAME(t) H5_##t##_reg_free_list
#ifndef H5_NO_REG_FREE_LISTS
#define H5FL_DEFINE_COMMON(t) H5FL_reg_head_t H5FL_REG_NAME(t) = {0, 0, 0, #t, sizeof(t), NULL}
#define H5FL_DEFINE(t) H5_DLL H5FL_DEFINE_COMMON(t)
#define H5FL_EXTERN(t) H5_DLLVAR H5FL_reg_head_t H5FL_REG_NAME(t)
#define H5FL_DEFINE_STATIC(t) static H5FL_DEFINE_COMMON(t)
#define H5FL_MALLOC(t) (t *)H5FL_reg_malloc(&(H5FL_REG_NAME(t)))
#define H5FL_CALLOC(t) (t *)H5FL_reg_calloc(&(H5FL_REG_NAME(t)))
#define H5FL_FREE(t, obj) (t *)H5FL_reg_free(&(H5FL_REG_NAME(t)), obj)
#else
#include "H5MMprivate.h"
#define H5FL_DEFINE_COMMON(t) int H5_ATTR_UNUSED H5FL_REG_NAME(t)
#define H5FL_DEFINE(t)        H5_DLL H5FL_DEFINE_COMMON(t)
#define H5FL_EXTERN(t)        H5_DLLVAR H5FL_DEFINE_COMMON(t)
#define H5FL_DEFINE_STATIC(t) static H5FL_DEFINE_COMMON(t)
#define H5FL_MALLOC(t)        (t *)H5MM_malloc(sizeof(t))
#define H5FL_CALLOC(t)        (t *)H5MM_calloc(sizeof(t))
#define H5FL_FREE(t, obj)     (t *)H5MM_xfree(obj)
#endif
typedef union H5FL_blk_list_t {
    size_t                 size;
    union H5FL_blk_list_t *next;
    double                 unused1;
    haddr_t                unused2;
} H5FL_blk_list_t;
typedef struct H5FL_blk_node_t {
    size_t                  size;
    unsigned                allocated;
    unsigned                onlist;
    H5FL_blk_list_t        *list;
    struct H5FL_blk_node_t *next;
    struct H5FL_blk_node_t *prev;
} H5FL_blk_node_t;
typedef struct H5FL_blk_head_t {
    bool             init;
    unsigned         allocated;
    unsigned         onlist;
    size_t           list_mem;
    const char      *name;
    H5FL_blk_node_t *head;
} H5FL_blk_head_t;
#define H5FL_BLK_NAME(t) H5_##t##_blk_free_list
#ifndef H5_NO_BLK_FREE_LISTS
#define H5FL_BLK_DEFINE_COMMON(t) H5FL_blk_head_t H5FL_BLK_NAME(t) = {0, 0, 0, 0, #t "_blk", NULL}
#define H5FL_BLK_DEFINE(t) H5_DLL H5FL_BLK_DEFINE_COMMON(t)
#define H5FL_BLK_EXTERN(t) H5_DLLVAR H5FL_blk_head_t H5FL_BLK_NAME(t)
#define H5FL_BLK_DEFINE_STATIC(t) static H5FL_BLK_DEFINE_COMMON(t)
#define H5FL_BLK_MALLOC(t, size) (uint8_t *)H5FL_blk_malloc(&(H5FL_BLK_NAME(t)), (size))
#define H5FL_BLK_CALLOC(t, size) (uint8_t *)H5FL_blk_calloc(&(H5FL_BLK_NAME(t)), (size))
#define H5FL_BLK_FREE(t, blk) (uint8_t *)H5FL_blk_free(&(H5FL_BLK_NAME(t)), blk)
#define H5FL_BLK_REALLOC(t, blk, new_size) (uint8_t *)H5FL_blk_realloc(&(H5FL_BLK_NAME(t)), (blk), (new_size))
#define H5FL_BLK_AVAIL(t, size) H5FL_blk_free_block_avail(&(H5FL_BLK_NAME(t)), size)
#else
#define H5FL_BLK_DEFINE_COMMON(t) int H5_ATTR_UNUSED H5FL_BLK_NAME(t)
#define H5FL_BLK_DEFINE(t)                 H5_DLL H5FL_BLK_DEFINE_COMMON(t)
#define H5FL_BLK_EXTERN(t)                 H5_DLLVAR H5FL_BLK_DEFINE_COMMON(t)
#define H5FL_BLK_DEFINE_STATIC(t)          static H5FL_BLK_DEFINE_COMMON(t)
#define H5FL_BLK_MALLOC(t, size)           (uint8_t *)H5MM_malloc(size)
#define H5FL_BLK_CALLOC(t, size)           (uint8_t *)H5MM_calloc(size)
#define H5FL_BLK_FREE(t, blk)              (uint8_t *)H5MM_xfree(blk)
#define H5FL_BLK_REALLOC(t, blk, new_size) (uint8_t *)H5MM_realloc(blk, new_size)
#define H5FL_BLK_AVAIL(t, size)            (false)
#endif
typedef union H5FL_arr_list_t {
    union H5FL_arr_list_t *next;
    size_t                 nelem;
    double                 unused1;
    haddr_t                unused2;
} H5FL_arr_list_t;
typedef struct H5FL_arr_node_t {
    size_t size;
    unsigned         allocated;
    unsigned         onlist;
    H5FL_arr_list_t *list;
} H5FL_arr_node_t;
typedef struct H5FL_arr_head_t {
    bool             init;
    unsigned         allocated;
    size_t           list_mem;
    const char      *name;
    int              maxelem;
    size_t           base_size;
    size_t           elem_size;
    H5FL_arr_node_t *list_arr;
} H5FL_arr_head_t;
#define H5FL_ARR_NAME(t) H5_##t##_arr_free_list
#ifndef H5_NO_ARR_FREE_LISTS
#define H5FL_ARR_DEFINE_COMMON(b, t, m)                                                                      \
    H5FL_arr_head_t H5FL_ARR_NAME(t) = {0, 0, 0, #t "_arr", m + 1, b, sizeof(t), NULL}
#define H5FL_ARR_DEFINE(t, m) H5_DLL H5FL_ARR_DEFINE_COMMON(0, t, m)
#define H5FL_BARR_DEFINE(b, t, m) H5_DLL H5FL_ARR_DEFINE_COMMON(sizeof(b), t, m)
#define H5FL_ARR_EXTERN(t) H5_DLLVAR H5FL_arr_head_t H5FL_ARR_NAME(t)
#define H5FL_ARR_DEFINE_STATIC(t, m) static H5FL_ARR_DEFINE_COMMON(0, t, m)
#define H5FL_BARR_DEFINE_STATIC(b, t, m) static H5FL_ARR_DEFINE_COMMON(sizeof(b), t, m)
#define H5FL_ARR_MALLOC(t, elem) H5FL_arr_malloc(&(H5FL_ARR_NAME(t)), (elem))
#define H5FL_ARR_CALLOC(t, elem) H5FL_arr_calloc(&(H5FL_ARR_NAME(t)), (elem))
#define H5FL_ARR_FREE(t, obj) (t *)H5FL_arr_free(&(H5FL_ARR_NAME(t)), obj)
#define H5FL_ARR_REALLOC(t, obj, new_elem) H5FL_arr_realloc(&(H5FL_ARR_NAME(t)), obj, (new_elem))
#else
#define H5FL_ARR_DEFINE_COMMON(t, m) size_t H5FL_ARR_NAME(t)
#define H5FL_ARR_DEFINE(t, m)              H5_DLL H5FL_ARR_DEFINE_COMMON(t, m) = 0
#define H5FL_BARR_DEFINE(b, t, m)          H5_DLL H5FL_ARR_DEFINE_COMMON(t, m) = sizeof(b)
#define H5FL_ARR_EXTERN(t)                 H5_DLLVAR H5FL_ARR_DEFINE_COMMON(t, m)
#define H5FL_ARR_DEFINE_STATIC(t, m)       static H5FL_ARR_DEFINE_COMMON(t, m) = 0
#define H5FL_BARR_DEFINE_STATIC(b, t, m)   static H5FL_ARR_DEFINE_COMMON(t, m) = sizeof(b)
#define H5FL_ARR_MALLOC(t, elem)           H5MM_malloc(H5FL_ARR_NAME(t) + ((elem) * sizeof(t)))
#define H5FL_ARR_CALLOC(t, elem)           H5MM_calloc(H5FL_ARR_NAME(t) + ((elem) * sizeof(t)))
#define H5FL_ARR_FREE(t, obj)              (t *)H5MM_xfree(obj)
#define H5FL_ARR_REALLOC(t, obj, new_elem) H5MM_realloc(obj, H5FL_ARR_NAME(t) + ((new_elem) * sizeof(t)))
#endif
typedef struct H5FL_seq_head_t {
    H5FL_blk_head_t queue;
    size_t          size;
} H5FL_seq_head_t;
#define H5FL_SEQ_NAME(t) H5_##t##_seq_free_list
#ifndef H5_NO_SEQ_FREE_LISTS
#define H5FL_SEQ_DEFINE_COMMON(t)                                                                            \
    H5FL_seq_head_t H5FL_SEQ_NAME(t) = {{0, 0, 0, 0, #t "_seq", NULL}, sizeof(t)}
#define H5FL_SEQ_DEFINE(t) H5_DLL H5FL_SEQ_DEFINE_COMMON(t)
#define H5FL_SEQ_EXTERN(t) H5_DLLVAR H5FL_seq_head_t H5FL_SEQ_NAME(t)
#define H5FL_SEQ_DEFINE_STATIC(t) static H5FL_SEQ_DEFINE_COMMON(t)
#define H5FL_SEQ_MALLOC(t, elem) (t *)H5FL_seq_malloc(&(H5FL_SEQ_NAME(t)), (elem))
#define H5FL_SEQ_CALLOC(t, elem) (t *)H5FL_seq_calloc(&(H5FL_SEQ_NAME(t)), (elem))
#define H5FL_SEQ_FREE(t, obj) (t *)H5FL_seq_free(&(H5FL_SEQ_NAME(t)), obj)
#define H5FL_SEQ_REALLOC(t, obj, new_elem) (t *)H5FL_seq_realloc(&(H5FL_SEQ_NAME(t)), obj, (new_elem))
#else
#define H5FL_SEQ_DEFINE_COMMON(t) int H5_ATTR_UNUSED H5FL_SEQ_NAME(t)
#define H5FL_SEQ_DEFINE(t)                 H5_DLL H5FL_SEQ_DEFINE_COMMON(t)
#define H5FL_SEQ_EXTERN(t)                 H5_DLLVAR H5FL_SEQ_DEFINE_COMMON(t)
#define H5FL_SEQ_DEFINE_STATIC(t)          static H5FL_SEQ_DEFINE_COMMON(t)
#define H5FL_SEQ_MALLOC(t, elem)           (t *)H5MM_malloc((elem) * sizeof(t))
#define H5FL_SEQ_CALLOC(t, elem)           (t *)H5MM_calloc((elem) * sizeof(t))
#define H5FL_SEQ_FREE(t, obj)              (t *)H5MM_xfree(obj)
#define H5FL_SEQ_REALLOC(t, obj, new_elem) (t *)H5MM_realloc(obj, (new_elem) * sizeof(t))
#endif
typedef struct H5FL_fac_gc_node_t H5FL_fac_gc_node_t;
typedef struct H5FL_fac_node_t    H5FL_fac_node_t;
typedef struct H5FL_fac_head_t {
    bool                init;
    unsigned            allocated;
    unsigned            onlist;
    size_t              size;
    H5FL_fac_node_t    *list;
    H5FL_fac_gc_node_t *prev_gc;
} H5FL_fac_head_t;
#ifndef H5_NO_FAC_FREE_LISTS
#define H5FL_FAC_MALLOC(f) H5FL_fac_malloc(f)
#define H5FL_FAC_CALLOC(f) H5FL_fac_calloc(f)
#define H5FL_FAC_FREE(f, obj) H5FL_fac_free(f, obj)
#else
#define H5FL_FAC_MALLOC(f)    H5MM_malloc(f->size)
#define H5FL_FAC_CALLOC(f)    H5MM_calloc(f->size)
#define H5FL_FAC_FREE(f, obj) H5MM_xfree(obj)
#endif
H5_DLL void  *H5FL_blk_malloc(H5FL_blk_head_t *head, size_t size) H5_ATTR_MALLOC;
H5_DLL void  *H5FL_blk_calloc(H5FL_blk_head_t *head, size_t size) H5_ATTR_MALLOC;
H5_DLL void  *H5FL_blk_free(H5FL_blk_head_t *head, void *block);
H5_DLL void  *H5FL_blk_realloc(H5FL_blk_head_t *head, void *block, size_t new_size);
H5_DLL htri_t H5FL_blk_free_block_avail(H5FL_blk_head_t *head, size_t size);
H5_DLL void *H5FL_reg_malloc(H5FL_reg_head_t *head) H5_ATTR_MALLOC;
H5_DLL void *H5FL_reg_calloc(H5FL_reg_head_t *head) H5_ATTR_MALLOC;
H5_DLL void *H5FL_reg_free(H5FL_reg_head_t *head, void *obj);
H5_DLL void *H5FL_arr_malloc(H5FL_arr_head_t *head, size_t elem) H5_ATTR_MALLOC;
H5_DLL void *H5FL_arr_calloc(H5FL_arr_head_t *head, size_t elem) H5_ATTR_MALLOC;
H5_DLL void *H5FL_arr_free(H5FL_arr_head_t *head, void *obj);
H5_DLL void *H5FL_arr_realloc(H5FL_arr_head_t *head, void *obj, size_t new_elem);
H5_DLL void *H5FL_seq_malloc(H5FL_seq_head_t *head, size_t elem) H5_ATTR_MALLOC;
H5_DLL void *H5FL_seq_calloc(H5FL_seq_head_t *head, size_t elem) H5_ATTR_MALLOC;
H5_DLL void *H5FL_seq_free(H5FL_seq_head_t *head, void *obj);
H5_DLL void *H5FL_seq_realloc(H5FL_seq_head_t *head, void *obj, size_t new_elem);
H5_DLL H5FL_fac_head_t *H5FL_fac_init(size_t size);
H5_DLL void            *H5FL_fac_malloc(H5FL_fac_head_t *head) H5_ATTR_MALLOC;
H5_DLL void            *H5FL_fac_calloc(H5FL_fac_head_t *head) H5_ATTR_MALLOC;
H5_DLL void            *H5FL_fac_free(H5FL_fac_head_t *head, void *obj);
H5_DLL herr_t           H5FL_fac_term(H5FL_fac_head_t *head);
H5_DLL herr_t H5FL_garbage_coll(void);
H5_DLL herr_t H5FL_set_free_list_limits(int reg_global_lim, int reg_list_lim, int arr_global_lim,
                                        int arr_list_lim, int blk_global_lim, int blk_list_lim,
                                        int fac_global_lim, int fac_list_lim);
H5_DLL herr_t H5FL_get_free_list_sizes(size_t *reg_size, size_t *arr_size, size_t *blk_size,
                                       size_t *fac_size);
H5_DLL int    H5FL_term_interface(void);
#endif
