% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{peeps}
\alias{peeps}
\title{A table of personal information for people all over the world}
\format{
A tibble with 100 rows and 14 variables:
\describe{
\item{name_given, name_family}{The given and family name of individual.}
\item{address}{The street address of the individual.}
\item{city}{The name of the city or locality in which the individual
resides.}
\item{state_prov}{The state or province associated with the \code{city} and
\code{address}. This is \code{NA} for individuals residing in countries where
subdivision data is not needed for generating a valid mailing address.}
\item{postcode}{The post code associated with the \code{city} and \code{address}.}
\item{country}{The 3-letter ISO 3166-1 country code representative of the
individual's country.}
\item{email_addr}{The individual's email address.}
\item{phone_number, country_code}{The individual's phone number and the
country code associated with the phone number.}
\item{gender}{The gender of the individual.}
\item{dob}{The individual's date of birth (DOB) in the ISO 8601 form of
\code{YYYY-MM-DD}.}
\item{height_cm, weight_kg}{The height and weight of the individual in
centimeters (cm) and kilograms (kg), respectively.}
}
}
\usage{
peeps
}
\description{
The \code{peeps} dataset contains records for one hundred people residing in ten
different countries. Each person in the table has address information along
with their email address and phone number. There are also personal
characteristics like date of birth, height, and weight. This data has been
synthesized, and so the names within the table have not been taken or based
on individuals in real life. The street addresses were generated from actual
street names within real geographic localities, however, the street numbers
were assigned randomly from a constrained number set. While these records do
not relate to real people, efforts were made to make the data as realistic as
possible.
}
\section{Dataset ID and Badge}{

DATA-8

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_peeps.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.11.0} (July 9, 2024)
}

\examples{
dplyr::glimpse(peeps)
}
\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
