% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{sterm_imp}
\alias{sterm_imp}
\title{variable importance of smooth terms in a GAM model}
\usage{
sterm_imp(gam_model, method = c("ssq", "var", "meanabs"))
}
\arguments{
\item{gam_model}{A GAM model object.}

\item{method}{A character string specifying the method to compute importance.
One of \code{"ssq"}, \code{"var"}, or \code{"meanabs"}.}
}
\value{
A \code{data.table} with columns:
\describe{
  \item{var}{Name of the smooth term.}
  \item{importance_pct}{Relative importance as a percentage.}
  \item{method}{The method used for calculating the importance.}
}
}
\description{
Evaluates the relative influence of each smooth term in a GAM model by computing
its contribution to the fitted values using the linear predictor matrix
(\code{type = "lpmatrix"}). Three summary methods are available: sum of squares,
variance, and mean absolute value across all observations.
#'
}
\examples{
# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# climate
dt.clim <- data.table::fread(system.file("extdata", "dt.clim.csv", package = "growthTrendR"))
# pre-data for model
dt.samples_clim <- prepare_samples_clim(dt.samples_trt, dt.clim)
dt.m <- dt.samples_clim[ageC >1]
# using gamm_spatial model as an example
m.sp <-gamm_spatial(data = dt.m, resp_scale = "resp_log",
       m.candidates = "bai_cm2 ~ log(ba_cm2_t_1) + s(ageC) + s(FFD)")

dt.m[, uid_site.fac:= as.factor(as.character(uid_site))]
dt.imp <- sterm_imp(m.sp$model$gam)

}
