% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{fitGPModel}
\alias{fitGPModel}
\title{Fits a \code{GPModel}}
\usage{
fitGPModel(likelihood = "gaussian", group_data = NULL,
  group_rand_coef_data = NULL, ind_effect_group_rand_coef = NULL,
  drop_intercept_group_rand_effect = NULL, gp_coords = NULL,
  gp_rand_coef_data = NULL, cov_function = "matern", cov_fct_shape = 1.5,
  gp_approx = "none", num_parallel_threads = NULL,
  matrix_inversion_method = "default", weights = NULL,
  likelihood_learning_rate = 1, cov_fct_taper_range = 1,
  cov_fct_taper_shape = 1, num_neighbors = NULL,
  vecchia_ordering = "random", ind_points_selection = "kmeans++",
  num_ind_points = NULL, cover_tree_radius = 1, seed = 0L,
  cluster_ids = NULL, free_raw_data = FALSE, y, X = NULL,
  params = list(), vecchia_approx = NULL, vecchia_pred_type = NULL,
  num_neighbors_pred = NULL, offset = NULL, fixed_effects = NULL,
  likelihood_additional_param = NULL)
}
\arguments{
\item{likelihood}{A \code{string} specifying the likelihood function (distribution) of the response variable. 
Available options:
\itemize{
\item{ "gaussian" }
\item{ "bernoulli_logit": Bernoulli likelihood with a logit link function for binary classification. Aliases: "binary", "binary_logit" }
\item{ "bernoulli_probit": Bernoulli likelihood with a probit link function for binary classification. Aliases: "binary_probit" }
\item{ "binomial_logit": Binomial likelihood with a logit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials. Aliases: "binomial"}
\item{ "binomial_probit": Binomial likelihood with a probit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials }
\item{ "beta_binomial": Beta-binomial likelihood with a logit link function. 
The response variable \code{y} needs to contain proportions of successes / trials, 
and the \code{weights} parameter needs to contain the numbers of trials. Aliases: "betabinomial", "beta-binomial"}
\item{ "poisson": Poisson likelihood with a log link function }
\item{ "negative_binomial": negative binomial likelihood with a log link function (aka "nbinom2", "negative_binomial_2"). 
The variance is mu * (mu + r) / r, mu = mean, r = shape, with this parametrization }
\item{ "negative_binomial_1": Negative binomial 1 (aka "nbinom1") likelihood with a log link function. 
The variance is mu * (1 + phi), mu = mean, phi = dispersion, with this parametrization }
\item{ "gamma": Gamma likelihood with a log link function }
\item{ "lognormal": Log-normal likelihood with a log link function }
\item{ "beta" : Beta likelihood with a logit link function (parametrization of Ferrari and Cribari-Neto, 2004)}
\item{ "t": t-distribution (e.g., for robust regression) }
\item{ "t_fix_df": t-distribution with the degrees-of-freedom (df) held fixed and not estimated. 
The df can be set via the \code{likelihood_additional_param} parameter }
\item{ "zero_inflated_gamma": Zero-inflated gamma likelihood. 
The log-transformed mean of the response variable equals the sum of fixed and random effects, E(y) = mu = exp(F(X) + Zb), 
and the rate parameter equals (1-p0) * gamma / mu, where p0 is the zero-inflation probability and gamma the shape parameter. 
I.e., the rate parameter depends on F(X) + Zb, and p0 and gamma are (univariate auxiliary) parameters that are estimated. 
Note that E(y) = mu above refers the the mean of the entire distribution and not just the positive part }
\item{ "zero_censored_power_transformed_normal": Likelihood of a censored and power-transformed normal variable 
for modeling data with a point mass at 0 and a continuous distribution for y > 0. 
The model used is Y = max(0,X)^lambda, X ~ N(mu, sigma^2), where mu = F(X) + Zb, 
and sigma and lambda are (auxiliary) parameters that are estimated. 
For more details on this model, see Sigrist et al. (2012, AOAS) "A dynamic nonstationary spatio-temporal model for short term prediction of precipitation" }
\item{ "gaussian_heteroscedastic": Gaussian likelihood where both the mean and the variance 
are related to fixed and random effects. This is currently only implemented for GPs with a 'vecchia' approximation }
\item{ Note: the first lines in the \href{https://github.com/fabsig/GPBoost/blob/master/include/GPBoost/likelihoods.h}{likelihoods source file} contain additional comments on the specific parametrizations used }
\item{ Note: other likelihoods can be implemented upon request }
}}

\item{group_data}{A \code{vector} or \code{matrix} whose columns are categorical grouping variables. 
The elements being group levels defining grouped random effects.
The elements of 'group_data' can be integer, double, or character.
The number of columns corresponds to the number of grouped (intercept) random effects}

\item{group_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data 
for grouped random coefficients}

\item{ind_effect_group_rand_coef}{A \code{vector} with \code{integer} indices that 
indicate the corresponding categorical grouping variable (=columns) in 'group_data' for 
every covariate in 'group_rand_coef_data'. Counting starts at 1.
The length of this index vector must equal the number of covariates in 'group_rand_coef_data'.
For instance, c(1,1,2) means that the first two covariates (=first two columns) in 'group_rand_coef_data'
have random coefficients corresponding to the first categorical grouping variable (=first column) in 'group_data',
and the third covariate (=third column) in 'group_rand_coef_data' has a random coefficient
corresponding to the second grouping variable (=second column) in 'group_data'}

\item{drop_intercept_group_rand_effect}{A \code{vector} of type \code{logical} (boolean). 
Indicates whether intercept random effects are dropped (only for random coefficients). 
If drop_intercept_group_rand_effect[k] is TRUE, the intercept random effect number k is dropped / not included. 
Only random effects with random slopes can be dropped.}

\item{gp_coords}{A \code{matrix} with numeric coordinates (= inputs / features) for defining Gaussian processes}

\item{gp_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data for
Gaussian process random coefficients}

\item{cov_function}{A \code{string} specifying the covariance function for the Gaussian process. 
Available options:
\itemize{
\item{ "matern": Matern covariance function with the smoothness specified by 
the \code{cov_fct_shape} parameter (using the parametrization of Rasmussen and Williams, 2006) }
\item{ "matern_estimate_shape": same as "matern" but the smoothness parameter is also estimated }
\item{ "matern_space_time": Spatio-temporal Matern covariance function with different range parameters for space and time. 
Note that the first column in \code{gp_coords} must correspond to the time dimension }
\item{ "matern_ard": anisotropic Matern covariance function with Automatic Relevance Determination (ARD), 
i.e., with a different range parameter for every coordinate dimension / column of \code{gp_coords} }
\item{ "matern_ard_estimate_shape": same as "matern_ard" but the smoothness parameter is also estimated }
\item{ "exponential": Exponential covariance function (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "gaussian": Gaussian, aka squared exponential, covariance function (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "gaussian_ard": anisotropic Gaussian, aka squared exponential, covariance function with Automatic Relevance Determination (ARD), 
i.e., with a different range parameter for every coordinate dimension / column of \code{gp_coords} }
\item{ "powered_exponential": powered exponential covariance function with the exponent specified by 
the \code{cov_fct_shape} parameter (using the parametrization of Diggle and Ribeiro, 2007) }
\item{ "wendland": Compactly supported Wendland covariance function (using the parametrization of Bevilacqua et al., 2019, AOS) }
\item{ "linear": linear covariance function. This corresponds to a Bayesian linear regression model with a Gaussian prior on the coefficients with a constant variance diagonal prior covariance, and the prior variance is estimated using empirical Bayes. }
}}

\item{cov_fct_shape}{A \code{numeric} specifying the shape parameter of the covariance function 
(e.g., smoothness parameter for Matern and Wendland covariance)  
This parameter is irrelevant for some covariance functions such as the exponential or Gaussian}

\item{gp_approx}{A \code{string} specifying the large data approximation
for Gaussian processes. Available options: 
\itemize{
\item{"none": No approximation }
\item{"vecchia": Vecchia approximation; see Sigrist (2022, JMLR) for more details }
\item{"full_scale_vecchia": Vecchia-inducing points full-scale (VIF) approximation; 
see Gyger, Furrer, and Sigrist (2025) for more details }
\item{"tapering": The covariance function is multiplied by 
a compactly supported Wendland correlation function }
\item{"fitc": Fully Independent Training Conditional approximation aka 
modified predictive process approximation; see Gyger, Furrer, and Sigrist (2024) for more details }
\item{"full_scale_tapering": Full-scale approximation combining an 
inducing point / predictive process approximation with tapering on the residual process; 
see Gyger, Furrer, and Sigrist (2024) for more details }
\item{"vecchia_latent": similar as "vecchia" but a Vecchia approximation is applied to the latent Gaussian process 
for likelihood == "gaussian". For likelihood != "gaussian", "vecchia" and "vecchia_latent" are equivalent }
}}

\item{num_parallel_threads}{An \code{integer} specifying the number of parallel threads for OMP. 
If num_parallel_threads = NULL, all available threads are used}

\item{matrix_inversion_method}{A \code{string} specifying the method used for inverting covariance matrices. 
Available options:
\itemize{
\item{"default": iterative methods where possible, otherwise Cholesky factorization }
\item{"cholesky": Cholesky factorization }
\item{"iterative": iterative methods. A combination of the conjugate gradient, the Lanczos algorithm, and other methods. 

This is currently only supported for the following cases: 
\itemize{
\item{ grouped random effects with more than one level }
\item{likelihood != "gaussian" and gp_approx == "vecchia" (non-Gaussian likelihoods with a Vecchia-Laplace approximation) }
\item{likelihood != "gaussian" and gp_approx == "full_scale_vecchia" (non-Gaussian likelihoods with a VIF approximation) }
\item{likelihood == "gaussian" and gp_approx == "full_scale_tapering" (Gaussian likelihood with a full-scale tapering approximation) }
}
}
}}

\item{weights}{A \code{vector} with sample weights}

\item{likelihood_learning_rate}{A \code{numeric} with a learning rate for the likelihood for generalized Bayesian inference (only non-Gaussian likelihoods)}

\item{cov_fct_taper_range}{A \code{numeric} specifying the range parameter 
of the Wendland covariance function and Wendland correlation taper function. 
We follow the notation of Bevilacqua et al. (2019, AOS)}

\item{cov_fct_taper_shape}{A \code{numeric} specifying the shape (=smoothness) parameter 
of the Wendland covariance function and Wendland correlation taper function. 
We follow the notation of Bevilacqua et al. (2019, AOS)}

\item{num_neighbors}{An \code{integer} specifying the number of neighbors for 
the Vecchia and VIF approximations. Internal default values if NULL: 
\itemize{
   \item{ 20 for gp_approx = "vecchia" }
   \item{ 30 for gp_approx = "full_scale_vecchia" }
   }
Note: for prediction, the number of neighbors can 
be set through the 'num_neighbors_pred' parameter in the 'set_prediction_data'
function. By default, num_neighbors_pred = 2 * num_neighbors. Further, 
the type of Vecchia approximation used for making predictions is set through  
the 'vecchia_pred_type' parameter in the 'set_prediction_data' function}

\item{vecchia_ordering}{A \code{string} specifying the ordering used in 
the Vecchia approximation. Available options:
\itemize{
\item{"none": the default ordering in the data is used }
\item{"random": a random ordering }
\item{"time": ordering accorrding to time (only for space-time models) }
\item{"time_random_space": ordering according to time and randomly for all 
spatial points with the same time points (only for space-time models) }
}}

\item{ind_points_selection}{A \code{string} specifying the method for choosing inducing points
Available options:
\itemize{
\item{"kmeans++: the k-means++ algorithm }
\item{"cover_tree": the cover tree algorithm }
\item{"random": random selection from data points }
}}

\item{num_ind_points}{An \code{integer} specifying the number of inducing 
points / knots for FITC, full_scale_tapering, and VIF approximations. Internal default values if NULL: 
\itemize{
   \item{ 500 for gp_approx = "FITC" and gp_approx = "full_scale_tapering" }
   \item{ 200 for gp_approx = "full_scale_vecchia" }
   }}

\item{cover_tree_radius}{A \code{numeric} specifying the radius (= "spatial resolution") 
for the cover tree algorithm}

\item{seed}{An \code{integer} specifying the seed used for model creation 
(e.g., random ordering in Vecchia approximation)}

\item{cluster_ids}{A \code{vector} with elements indicating independent realizations of 
random effects / Gaussian processes (same values = same process realization).
The elements of 'cluster_ids' can be integer, double, or character.}

\item{free_raw_data}{A \code{boolean}. If TRUE, the data (groups, coordinates, covariate data for random coefficients) 
is freed in R after initialization}

\item{y}{A \code{vector} with response variable data}

\item{X}{A \code{matrix} with numeric covariate data for the 
fixed effects linear regression term (if there is one)}

\item{params}{A \code{list} with parameters for the estimation / optimization
 \itemize{
    \item{trace: \code{boolean} (default = FALSE). 
    If TRUE, information on the progress of the parameter
    optimization is printed}
    \item{std_dev: \code{boolean} (default = TRUE). 
    If TRUE, approximate standard deviations are calculated for the covariance and linear regression parameters 
    (= square root of diagonal of the inverse Fisher information for Gaussian likelihoods and 
    square root of diagonal of a numerically approximated inverse Hessian for non-Gaussian likelihoods) }
    \item{init_cov_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). The order is same as the order 
    of the parameters in the summary function: first is the error variance 
    (only for "gaussian" likelihood), next follow the variances of the 
    grouped random effects (if there are any, in the order provided in 'group_data'), 
    and then follow the marginal variance and the ranges of the Gaussian process. 
    If there are multiple Gaussian processes, then the variances and ranges follow alternatingly.
    If 'init_cov_pars = NULL', an internal choice is used that depends on the 
    likelihood and the random effects type and covariance function. 
    If you select the option 'trace = TRUE' in the 'params' argument, 
    you will see the first initial covariance parameters in iteration 0. }
    \item{init_coef: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for the regression coefficients (if there are any, can be NULL) }
    \item{init_aux_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for additional parameters for non-Gaussian likelihoods 
    (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{estimate_cov_par_index: \code{vector} with \code{integer} (default = -1). 
    This allows for disabling the estimation of some (or all) covariance parameters if estimate_cov_par_index != -1. 
    'estimate_cov_par_index' should then be a vector with length equal to the number of covariance parameters, 
    and estimate_cov_par_index[i] should be of bool type indicating whether parameter number i is estimated or not. 
    For instance, estimate_cov_par_index = c(1,1,0) means that the first two covariance parameters 
    are estimated and the last one not.}  
    \item{estimate_aux_pars: \code{boolean} (default = TRUE). 
    If TRUE, additional parameters for non-Gaussian likelihoods 
    are also estimated (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{optimizer_cov: \code{string} (default = "lbfgs"). 
    Optimizer used for estimating covariance parameters. 
    Options: "lbfgs", "gradient_descent", "fisher_scoring", "newton", "nelder_mead".
    If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'optimizer_cov' is also used for those }
    \item{optimizer_coef: \code{string} (default = "wls" for Gaussian likelihoods and "lbfgs" for other likelihoods). 
    Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent", "lbfgs", "wls", "nelder_mead". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance parameters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    If 'optimizer_cov' is set to "nelder_mead" or "lbfgs", 
    'optimizer_coef' is automatically also set to the same value.}
    \item{maxit: \code{integer} (default = 1000). 
    Maximal number of iterations for optimization algorithm }
    \item{delta_rel_conv: \code{numeric} (default = 1E-6 except for "nelder_mead" for which the default is 1E-8). 
    Convergence tolerance. The algorithm stops if the relative change 
    in either the (approximate) log-likelihood or the parameters is below this value. 
    If < 0, internal default values are used }
    \item{cg_max_num_it: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithms }
    \item{cg_max_num_it_tridiag: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithm 
    when being run as Lanczos algorithm for tridiagonalization }
    \item{cg_delta_conv: \code{numeric} (default = 1E-2).
    Tolerance level for L2 norm of residuals for checking convergence 
    in conjugate gradient algorithm when being used for parameter estimation }
    \item{num_rand_vec_trace: \code{integer} (default = 50). 
    Number of random vectors (e.g., Rademacher) for stochastic approximation of the trace of a matrix }
    \item{reuse_rand_vec_trace: \code{boolean} (default = TRUE). 
    If true, random vectors (e.g., Rademacher) for stochastic approximations 
    of the trace of a matrix are sampled only once at the beginning of 
    the parameter estimation and reused in later trace approximations.
    Otherwise they are sampled every time a trace is calculated }
    \item{seed_rand_vec_trace: \code{integer} (default = 1). 
    Seed number to generate random vectors (e.g., Rademacher) }
    \item{cg_preconditioner_type (\code{string}):
    Type of preconditioner used for conjugate gradient algorithms.
    \itemize{
      \item Options for grouped random effects: 
      \itemize{
          \item "ssor" (= default): SSOR preconditioner
          \item "incomplete_cholesky": zero fill-in incomplete Cholesky factorization
          }
      \item Options for likelihood != "gaussian" and gp_approx == "vecchia" or
      likelihood == "gaussian" and gp_approx == "vecchia_latent": 
        \itemize{
          \item{"vadu" (= default): (B^T * (D^-1 + W) * B) as preconditioner for inverting (B^T * D^-1 * B + W), 
      where B^T * D^-1 * B approx= Sigma^-1 }
          \item{"fitc": FITC / modified predictive process preconditioner for inverting (B^-1 * D * B^-T + W^-1)}
          \item{"pivoted_cholesky": (Lk * Lk^T + W^-1) as preconditioner for inverting (B^-1 * D * B^-T + W^-1), 
      where Lk is a low-rank pivoted Cholesky approximation for Sigma and B^-1 * D * B^-T approx= Sigma }
          \item{"incomplete_cholesky": zero fill-in incomplete (reverse) Cholesky factorization of 
          (B^T * D^-1 * B + W) using the sparsity pattern of B^T * D^-1 * B approx= Sigma^-1 }
        }
      \item Options for likelihood != "gaussian" and gp_approx == "full_scale_vecchia": 
        \itemize{
          \item{"fitc" ( = default): FITC / modified predictive process preconditioner }
          \item{"vifdu": VIF with diagonal update preconditioner }
        }
      \item Options for likelihood == "gaussian" and gp_approx == "full_scale_tapering": 
        \itemize{
          \item{"fitc" (= default): modified predictive process preconditioner }
          \item{"none": no preconditioner }
      }
    }
    }
    \item{fitc_piv_chol_preconditioner_rank (\code{integer} ): 
    Rank of the FITC and pivoted Cholesky decomposition preconditioners for 
    iterative methods for Vecchia and VIF approximations 
    (for full_scale_tapering, the same inducing points as in the approximation as used).
    Internal default values if NULL or < 0: 
    \itemize{
          \item{ 200 for the FITC preconditioner }
          \item{ 50 for the pivoted Cholesky decomposition preconditioner }
          }
      }
    \item{convergence_criterion: \code{string} (default = "relative_change_in_log_likelihood", only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" or "relative_change_in_parameters" }
    \item{lr_cov: \code{numeric} (default = 0.1 for "gradient_descent" and 1. otherwise, only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    Initial learning rate for covariance parameters if a gradient-based optimization method is used 
    \itemize{
    \item{If lr_cov < 0, internal default values are used (0.1 for "gradient_descent" and 1. otherwise) }
    \item{If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'lr_cov' is also used for those }
    \item{For "lbfgs", this is divided by the norm of the gradient in the first iteration }}}
    \item{lr_coef: \code{numeric} (default = 0.1, only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    Learning rate for fixed effect regression coefficients if gradient descent is used }
    \item{use_nesterov_acc: \code{boolean} (default = TRUE, only relevant for "gradient_descent"). 
    If TRUE Nesterov acceleration is used.
    This is used only for gradient descent }
    \item{acc_rate_coef: \code{numeric} (default = 0.5, only relevant for "gradient_descent"). 
    Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration }
    \item{acc_rate_cov: \code{numeric} (default = 0.5, only relevant for "gradient_descent"). 
    Acceleration rate for covariance parameters for Nesterov acceleration }
    \item{momentum_offset: \code{integer} (Default = 2, only relevant for "gradient_descent")}. 
    Number of iterations for which no momentum is applied in the beginning.
    \item{m_lbfgs: \code{integer} (Default = 6)}. Number of corrections to approximate the inverse Hessian matrix for the "lbfgs" optimizer
    \item{delta_conv_mode_finding: \code{numeric} (Default = 1E-8)}. Convergence tolerance in mode finding algorithm for Laplace approximation for non-Gaussian likelihoods
}}

\item{vecchia_approx}{Discontinued. Use the argument \code{gp_approx} instead}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions.
This is discontinued here. Use the function 'set_prediction_data' to specify this}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for making predictions.
This is discontinued here. Use the function 'set_prediction_data' to specify this}

\item{offset}{A \code{numeric} \code{vector} with 
additional fixed effects contributions that are added to the linear predictor (= offset). 
The length of this vector needs to equal the number of training data points.}

\item{fixed_effects}{This is discontinued. Use the renamed equivalent argument \code{offset} instead}

\item{likelihood_additional_param}{A \code{numeric} specifying an additional parameter for the \code{likelihood} 
which cannot be estimated for this \code{likelihood} (e.g., degrees of freedom for \code{likelihood = "t_fix_df"}). 
This is not to be confused with any auxiliary parameters that can be estimated and accessed through 
the function \code{get_aux_pars} after estimation.
Note that this \code{likelihood_additional_param} parameter is irrelevant for many likelihoods.
If \code{likelihood_additional_param = NULL}, the following internal default values are used:
\itemize{
\item{ df = 2 for likelihood = "t_fix_df"}
}}
}
\value{
A fitted \code{GPModel}
}
\description{
Estimates the parameters of a \code{GPModel} by maximizing the marginal likelihood
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

\donttest{
data(GPBoost_data, package = "gpboost")
# Add intercept column
X1 <- cbind(rep(1,dim(X)[1]),X)
X_test1 <- cbind(rep(1,dim(X_test)[1]),X_test)

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- fitGPModel(group_data = group_data[,1], y = y, X = X1,
                       likelihood="gaussian", params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, group_data_pred = group_data_test[,1], 
                X_pred = X_test1, predict_var = TRUE)
pred$mu # Predicted mean
pred$var # Predicted variances
# Also predict covariance matrix
pred <- predict(gp_model, group_data_pred = group_data_test[,1], 
                X_pred = X_test1, predict_cov_mat = TRUE)
pred$mu # Predicted mean
pred$cov # Predicted covariance

#--------------------Two crossed random effects and a random slope----------------
gp_model <- fitGPModel(group_data = group_data, likelihood="gaussian",
                       group_rand_coef_data = X[,2],
                       ind_effect_group_rand_coef = 1,
                       y = y, X = X1, params = list(std_dev = TRUE))
summary(gp_model)

#--------------------Gaussian process model----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                       likelihood="gaussian", y = y, X = X1, params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, gp_coords_pred = coords_test, 
                X_pred = X_test1, predict_cov_mat = TRUE)
pred$mu # Predicted (posterior) mean of GP
pred$cov # Predicted (posterior) covariance matrix of GP

#--------------------Gaussian process model with Vecchia approximation----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                       gp_approx = "vecchia", num_neighbors = 20,
                       likelihood="gaussian", y = y)
summary(gp_model)

#--------------------Gaussian process model with random coefficients----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                       gp_rand_coef_data = X[,2], y=y,
                       likelihood = "gaussian", params = list(std_dev = TRUE))
summary(gp_model)

#--------------------Combine Gaussian process with grouped random effects----------------
gp_model <- fitGPModel(group_data = group_data,
                       gp_coords = coords, cov_function = "matern", cov_fct_shape = 1.5,
                       likelihood = "gaussian", y = y, X = X1, params = list(std_dev = TRUE))
summary(gp_model)
}

}
\author{
Fabio Sigrist
}
