% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{model.frame.gkwreg}
\alias{model.frame.gkwreg}
\title{Extract Model Frame from GKw Regression Model}
\usage{
\method{model.frame}{gkwreg}(formula, ...)
}
\arguments{
\item{formula}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
A data frame containing the variables used in fitting the model.
}
\description{
Extracts the model frame from a fitted Generalized Kumaraswamy regression
model object.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
head(model.frame(fit))
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{model.matrix.gkwreg}}
}
\author{
Lopes, J. E.
}
