% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_corset_elongated.R
\name{gg_corset_elongated}
\alias{gg_corset_elongated}
\title{CORSET PLOT ELONGATED}
\arguments{
\item{data}{The name of the data frame.}

\item{x_var}{The name of the x_axis variable.}

\item{x_vals}{The values of the two time points.}

\item{y_var}{The repeated measure variable name.}

\item{group}{The name of units measured at each time point such as 'ID'. The trajectories of these units are visualized by the lines of the corset plot.}

\item{c_var}{The name of variable to visualize by line colour, such as percent change.}

\item{eyelets}{Optional (default is FALSE). If set to true, this will visualize one of two mean types by c_var, as defined by the 'e_type' argument.}

\item{e_type}{Optional eyelet type if the eyelets parameter is set to TRUE. One of "SE" or "SD". The default is standard error ("SE") means. Alternatively, standard deviations ("SD") with means can be specified, which include horizontal lines to denote +1 and -1 standard deviation. Note that the visualization of standard deviations works best in tandem with the faceted option.}

\item{faceted}{Optional (default is FALSE). If set to true, the c_var will be faceted.}

\item{facet_design}{Optional facet type when the faceted parameter is set to TRUE. One of "original","group", or "line". The default is "original", which provides facets void of any special features. The "group" option includes the overall distribution of the entire sample in the background of each facet (which defaults to the 'vio_fill' colour), alongside each distribution for each c_var group. The "line" option includes all individual trajectories in the background of each facet using a soft grey (default) or custom colour as chosen by 'line_col' argument.}

\item{vio_fill}{Optional (defaults to a soft black). Use to change the fill colour of the half violins.}

\item{line_size}{Optional. Use to change the size (thickness) of the lines which visualize change for each unit identified by the group variable. Default is 0.25.}

\item{line_col}{Optional custom colour of the background individual lines when the facet_design is set to "line". Defaults to a soft grey.}

\item{line_dodge}{Optional. Use to change the amount of vertical dodge of the lines which visualize each unit of the group variable. Default is 0.1.}
}
\value{
ggplot2 graphical object
}
\description{
This function visualizes a corset plot in long format.
}
\examples{

long.df <- data.frame(id = c(rep(1:20,2)),
             time = c(rep(c("pre","post"),each = 20)),
             days  = c(3,4,7,5,6,3,4,1,7,0,5,2,0,1,6,2,1,7,4,6,
                       5,5,7,3,0,3,3,2,7,0,3,4,3,3,7,0,0,6,5,6),
             change = c(2,1,0,-2,-6,0,-1,1,0,0,-2,2,3,2,1,-2,-1,-1,1,0,
                        2,1,0,-2,-6,0,-1,1,0,0,-2,2,3,2,1,-2,-1,-1,1,0))

long.df$direction <- ifelse(long.df$change==0,"No Change",
                           ifelse(long.df$change>0,"Increase","Decrease"))

gg_corset_elongated(data = long.df, x_var = "time",
                   x_vals = c("pre","post"), y_var = "days",
                   group = "id", c_var = "change")

## Create groupings based on direction of change to use for eyelets:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction", eyelets = TRUE)

## Create faceted corset plots based on direction of change:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction", faceted = TRUE)

## Create faceted corset plots with standard deviation eyelets:

gg_corset_elongated(data = long.df, x_var = "time", x_vals = c("pre","post"),
                    y_var = "days", group = "id", c_var = "direction",
                    e_type = "SD", faceted = TRUE)

}
