% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookinstsub_bib.R
\name{bookinstsub_bib}
\alias{bookinstsub_bib}
\title{Function for preparing metadata of institutional book chapters for automatic insertion into scientific articles}
\usage{
bookinstsub_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a institutional books chapters.}

\item{input_tam}{is the length of the dataframe with the institutional books chapters, obtained using package bibliorefer.}
}
\value{
The output of the bookinstsub_bib function is the file with the .bib extension of institutional book chapters in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\description{
The bookinstsub_bib function prepares the metadata of institutional book chapters to be automatically included in a scientific article. The bookinstsub_bib function internally calls two support functions. The output of the bookinstsub_bib function is the file with the .bib extension of institutional book chapters in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","compinst2.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 6

#Calls the function bookinstsub_bib
bookinstsublister_bibtex <- bookinstsub_bib(input_date, input_tam)
bookinstsublister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
