% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-terrain-analysis.R
\name{integrate_terrain_analysis}
\alias{integrate_terrain_analysis}
\title{Integrate terrain analysis with vector data}
\usage{
integrate_terrain_analysis(
  vector_data,
  elevation_raster,
  terrain_vars = c("slope", "aspect", "TRI", "TPI", "flowdir"),
  custom_terrain_functions = NULL,
  extraction_method = "simple"
)
}
\arguments{
\item{vector_data}{Vector data (points, lines, or polygons)}

\item{elevation_raster}{Digital elevation model}

\item{terrain_vars}{Terrain variables to calculate}

\item{custom_terrain_functions}{Custom terrain analysis functions}

\item{extraction_method}{Method for extracting terrain values}
}
\value{
sf object with terrain attributes
}
\description{
Specialized function for terrain analysis integration. Calculates terrain
variables from DEM and extracts values to vector data points/polygons.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Extract terrain variables for study sites
sites_with_terrain <- integrate_terrain_analysis(
  vector_data = "study_sites.shp",
  elevation_raster = "dem.tif",
  terrain_vars = c("slope", "aspect", "TRI", "TPI")
)

# Use custom terrain functions
custom_functions <- list(
  ruggedness = function(sf_data) {
    sf_data$slope * sf_data$TRI
  }
)

terrain_analysis <- integrate_terrain_analysis(
  vector_data = field_boundaries,
  elevation_raster = dem_raster,
  custom_terrain_functions = custom_functions
)
}

}
