% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-visualization.R
\name{create_comparison_map}
\alias{create_comparison_map}
\title{Create comparison map (before/after, side-by-side)}
\usage{
create_comparison_map(
  data1,
  data2,
  comparison_type = "side_by_side",
  titles = c("Dataset 1", "Dataset 2"),
  region_boundary = NULL,
  color_scheme = "viridis",
  output_file = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data1}{First dataset (before, reference)}

\item{data2}{Second dataset (after, comparison)}

\item{comparison_type}{Type: "side_by_side", "difference"}

\item{titles}{Titles for each dataset}

\item{region_boundary}{Optional region boundary}

\item{color_scheme}{Color scheme for datasets}

\item{output_file}{Optional output file path}

\item{verbose}{Print progress messages}
}
\value{
NULL (plots directly to device) or file path if saved
}
\description{
Create comparison maps showing before/after analysis or side-by-side comparisons
using reliable terra plotting.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Before/after NDVI comparison
create_comparison_map("ndvi_2020.tif", "ndvi_2023.tif",
                     comparison_type = "side_by_side",
                     titles = c("2020", "2023"),
                     output_file = "ndvi_comparison.png")
}

}
