% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodetector.R
\name{ecological_detector}
\alias{ecological_detector}
\title{ecological detector}
\usage{
ecological_detector(y, x1, x2, alpha = 0.95)
}
\arguments{
\item{y}{Dependent variable, continuous numeric vector.}

\item{x1}{Covariate \eqn{X_1}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{x2}{Covariate \eqn{X_2}, \code{factor}, \code{character} or \code{discrete numeric}.}

\item{alpha}{(optional) Confidence level of the interval,default is \code{0.95}.}
}
\value{
A list.
\describe{
\item{\code{F-statistic}}{the result of F statistic for ecological detector}
\item{\code{P-value}}{the result of P value for ecological detector}
\item{\code{Ecological}}{is there a significant difference between the two factors \eqn{X_1} and \eqn{X_2} on the spatial distribution of the attribute \eqn{Y}}
}
}
\description{
Compare the effects of two factors \eqn{X_1} and \eqn{X_2} on the spatial distribution of the attribute \eqn{Y}.
}
\examples{
ecological_detector(y = 1:7,
                    x1 = c('x',rep('y',3),rep('z',3)),
                    x2 = c(rep('a',2),rep('b',2),rep('c',3)))

}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
