% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_update_plugin}
\alias{g6_update_plugin}
\title{Update a plugin in a g6 graph via proxy}
\usage{
g6_update_plugin(graph, key, ...)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{key}{Character string identifying the plugin to update.}

\item{...}{Named arguments representing the plugin configuration options to update
and their new values.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function allows updating the configuration of an existing plugin in a g6 graph
instance using a proxy object within a Shiny application.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

The function allows dynamically updating the configuration of an existing plugin
without having to reinitialize it. This is useful for changing plugin behavior
or appearance in response to user interactions.
}
\seealso{
\code{\link{g6_proxy}}, \code{\link{g6_add_plugin}}
}
