% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_add_plugin}
\alias{g6_add_plugin}
\title{Add a plugin to a g6 graph via proxy}
\usage{
g6_add_plugin(graph, ...)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{...}{Named arguments where each name is a plugin type and each value is a
list of configuration options for that plugin.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function adds one or more plugins to an existing g6 graph instance
using a proxy object within a Shiny application.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

G6 plugins extend the functionality of the graph visualization with features like
minimaps, toolbar controls, contextual menus, and more. This function allows adding
these plugins dynamically after the graph has been initialized.
}
\seealso{
\code{\link{g6_proxy}}, \code{\link{g6_update_plugin}}
}
