% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzer.R
\name{analyze_internal_dependencies_multi}
\alias{analyze_internal_dependencies_multi}
\title{Analyze internal dependencies in R source files}
\usage{
analyze_internal_dependencies_multi(file_paths)
}
\arguments{
\item{file_paths}{Character vector of R file paths to analyze.}
}
\value{
A list with the following components:
\describe{
\item{dependency_map}{Named list mapping function names to character vectors
of their dependencies}
\item{env}{Environment containing all parsed functions}
\item{all_code_lines}{Character vector of all code lines from all files}
\item{function_file_map}{Named list mapping function names to their source
file paths}
\item{duplicates}{List of functions defined in multiple files with their
source locations}
}
}
\description{
Parses multiple R files to identify function definitions and their internal
dependencies. Creates a comprehensive map of which functions call which other
functions within the analyzed codebase.
}
\details{
This function uses \code{codetools::findGlobals()} to detect function calls
within function bodies. Only functions defined within the analyzed files are
tracked. External package functions and base R functions are not included in
the dependency map.
}
\examples{
# Create temporary R files for demonstration
temp_file1 <- tempfile(fileext = ".R")
temp_file2 <- tempfile(fileext = ".R")

# Write sample R code to temporary files
writeLines(c(
  "add_numbers <- function(a, b) {",
  "  a + b",
  "}",
  "",
  "calculate_sum <- function(x) {",
  "  add_numbers(x, 10)",
  "}"
), temp_file1)

writeLines(c(
  "multiply <- function(a, b) {",
  "  a * b",
  "}",
  "",
  "process_data <- function(x) {",
  "  result <- add_numbers(x, 5)",
  "  multiply(result, 2)",
  "}"
), temp_file2)

# Analyze the files
dep_info <- analyze_internal_dependencies_multi(c(temp_file1, temp_file2))

# View the dependency map
print(dep_info$dependency_map)

# Check for duplicate function definitions
if (length(dep_info$duplicates) > 0) {
  message("Warning: Functions defined in multiple files:")
  print(dep_info$duplicates)
}

# Clean up
unlink(c(temp_file1, temp_file2))
}
