% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corDensity.R
\name{corDensity}
\alias{corDensity}
\title{Generate the marginal density of a correlation from a uniformly 
sampled R matrix.}
\usage{
corDensity(NVar)
}
\arguments{
\item{NVar}{(integer) The order of the correlation matrix.}
}
\value{
\code{corDensity} returns the following objects:
\itemize{
   \item  \strong{r} (numeric) A sequence of numbers from -1, to 1 in .001 
   increments.
   \item  \strong{rDensity} (numeric) The density of \code{r}.
}
}
\description{
Generate the marginal density of a correlation from a uniformly 
sampled R matrix.
}
\examples{

  out <- corDensity(NVar = 5)
  
  plot(out$r, out$rDensity, 
       typ = "l",
       xlab = "r",
       ylab = "Density of r",
       main = "")
}
\references{
Hürlimann, W.  (2012).  Positive semi-definite correlation 
matrices: Recursive algorithmic generation and volume measure.  
Pure Mathematical Science, 1(3), 137--149.  

Joe, H.  (2006).  Generating random correlation matrices based on 
partial correlations. Journal of Multivariate Analysis, 97(10), 2177--2189.
}
\author{
Niels G. Waller
}
