% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_02_fof_pc.R
\name{fof_pc_real_time}
\alias{fof_pc_real_time}
\title{Get a list of function-on-function linear regression models estimated
on functional data
each evolving up to an intermediate domain point.}
\usage{
fof_pc_real_time(
  mfdobj_y_list,
  mfdobj_x_list,
  tot_variance_explained_x = 0.95,
  tot_variance_explained_y = 0.95,
  tot_variance_explained_res = 0.95,
  components_x = NULL,
  components_y = NULL,
  type_residuals = "standard",
  ncores = 1
)
}
\arguments{
\item{mfdobj_y_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects,
each evolving up to an intermediate domain point,
with observations of the functional response variable.}

\item{mfdobj_x_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects,
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.}

\item{tot_variance_explained_x}{See \code{\link{fof_pc}}.}

\item{tot_variance_explained_y}{See \code{\link{fof_pc}}.}

\item{tot_variance_explained_res}{See \code{\link{fof_pc}}.}

\item{components_x}{See \code{\link{fof_pc}}.}

\item{components_y}{See \code{\link{fof_pc}}.}

\item{type_residuals}{See \code{\link{fof_pc}}.}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating objects separately for different instants.}
}
\value{
A list of lists each produced by \code{\link{fof_pc}},
corresponding to a given instant.
}
\description{
This function produces a list of objects,
each of them contains the result of applying \code{\link{fof_pc}} to
a functional response variable and multivariate functional covariates
evolved up to an intermediate domain point.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
mfdobj_y_list <- get_mfd_list_real_time(air["NO2"],
                                        n_basis = 15,
                                        lambda = 1e-2,
                                        k_seq = c(0.5, 0.75, 1))
mfdobj_x_list <- get_mfd_list_real_time(air[c("CO", "temperature")],
                                        n_basis = 15,
                                        lambda = 1e-2,
                                        k_seq = c(0.5, 0.75, 1))
mod_list <- fof_pc_real_time(mfdobj_y_list, mfdobj_x_list)

}
\seealso{
\code{\link{fof_pc}},
\code{\link{get_mfd_df_real_time}},
\code{\link{get_mfd_list_real_time}}
}
\author{
C. Capezza, F. Centofanti
}
