% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMixHMMR.R
\docType{class}
\name{ModelMixHMMR-class}
\alias{ModelMixHMMR-class}
\alias{ModelMixHMMR}
\title{A Reference Class which represents a fitted mixture of HMMR model.}
\description{
ModelMixHMMR represents an estimated mixture of HMMR model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamMixHMMR} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatMixHMMR} object. It contains all the
statistics associated to the MixHMMR model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("clustered", "smoothed", "loglikelihood"), ...)}}{Plot method
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"clustered" = } Clustered curves (field
        \code{klas} of class \link{StatMixHMMR}).
      \item \code{"smoothed" = } Smoothed signal (field
        \code{smoothed} of class {StatMixHMMR}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatMixHMMR}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(toydataset)
x <- toydataset$x
Y <- t(toydataset[,2:ncol(toydataset)])

mixhmmr <- emMixHMMR(X = x, Y = Y, K = 3, R = 3, p = 1, verbose = TRUE)

# mixhmmr is a ModelMixHMMR object. It contains some methods such as 'summary' and 'plot'
mixhmmr$summary()
mixhmmr$plot()

# mixhmmr has also two fields, stat and param which are reference classes as well

# Log-likelihood:
mixhmmr$stat$loglik

# Parameters of the polynomial regressions:
mixhmmr$param$beta
}
\seealso{
\link{ParamMixHMMR}, \link{StatMixHMMR}
}
