% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-zstatistic.R
\name{select_zstatistic}
\alias{select_zstatistic}
\title{Z-Statistic Method for Distribution Selection}
\usage{
select_zstatistic(data, ns_years = NULL, ns_structure = NULL, samples = 10000L)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}

\item{samples}{Integer scalar. The number of bootstrap samples. Default is 10000.}
}
\value{
A list with the results of distribution selection:
\itemize{
\item \code{method}: \code{"Z-selection"}.
\item \code{decomposed_data}: The detrended dataset used to compute the L-moments. For S-FFA,
this is the \code{data} argument. For NS-FFA, it is output of \code{\link[=data_decomposition]{data_decomposition()}}.
\item \code{metrics}: List of computed Z-statistics for each candidate distribution.
\item \code{recommendation}: Name of the distribution with the smallest Z-statistic.
\item \code{reg_params}: Kappa distribution parameters for the data.
\item \code{reg_bias_t4}: Bias of the L-kurtosis from the bootstrap.
\item \code{reg_std_t4}: Standard deviation of the L-kurtosis from the bootstrap.
\item \code{log_params}: Kappa distribution parameters for the log-transformed data.
\item \code{log_bias_t4}: Bias of the L-kurtosis from the bootstrap using \code{log_params}.
\item \code{log_std_t4}: Standard deviation of the L-kurtosis from the bootstrap using \code{log_params}.
}
}
\description{
Selects the best-fit distribution by comparing a bias-corrected Z-statistic for
the sample L-kurtosis (\eqn{\tau_4}) against the theoretical L-moments for a set
of candidate distributions. The distribution with the smallest absolute Z-statistic
is selected.

\strong{For NS-FFA}: To select a distribution for a nonstationary model, include the
observation years (\code{ns_years}) and the nonstationary model structure
(\code{ns_structure}). Then, this method will detrend the original, nonstationary data
internally using the \code{\link[=data_decomposition]{data_decomposition()}} function prior to distribution selection.
}
\details{
First, this method fits a four-parameter Kappa distribution to both the original and
log-transformed data. Then, bootstrapping is used to estimate the bias and
variance of the L-kurtosis. These values, along with the difference between the sample
and theoretical L-kurtosis, are used to compute the Z-statistic for each distribution.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
select_zstatistic(data)

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
\seealso{
\code{\link[=select_ldistance]{select_ldistance()}}, \code{\link[=select_lkurtosis]{select_lkurtosis()}}, \code{\link[=fit_lmoments_kappa]{fit_lmoments_kappa()}},
\code{\link[=utils_quantiles]{utils_quantiles()}}, \code{\link[=plot_lmom_diagram]{plot_lmom_diagram()}}
}
