% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-ldistance.R
\name{select_ldistance}
\alias{select_ldistance}
\title{L-Distance Method for Distribution Selection}
\usage{
select_ldistance(data, ns_years = NULL, ns_structure = NULL)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
A list with the results of distribution selection:
\itemize{
\item \code{method}: \code{"L-distance"}.
\item \code{decomposed_data}: The detrended dataset used to compute the L-moments. For S-FFA,
this is the \code{data} argument. For NS-FFA, it is output of \code{\link[=data_decomposition]{data_decomposition()}}.
\item \code{metrics}: A list of L-distance metrics for each candidate distribution.
\item \code{recommendation}: The name of the distribution with the smallest L-distance.
}
}
\description{
Selects a distribution from a set of candidate distributions by minimizing the
Euclidean distance between the theoretical L-moment ratios \eqn{(\tau_3, \tau_4)}
and the sample L-moment ratios \eqn{(t_3, t_4)}.

\strong{For NS-FFA}: To select a distribution for a nonstationary model, include the
observation years (\code{ns_years}) and the nonstationary model structure
(\code{ns_structure}). Then, this method will detrend the original, nonstationary data
internally using the \code{\link[=data_decomposition]{data_decomposition()}} function prior to distribution selection.
}
\details{
For each candidate distribution, this method computes the Euclidean distance between
sample L-moment ratios (\eqn{\tau_3}, \eqn{\tau_4}) and the closest point on the
theoretical distribution's L-moment curve. For two-parameter distributions (Gumbel,
Normal, Log-Normal), the theoretical L-moment ratios are compared directly with
the sample L-moment ratios. The distribution with the minimum distance is selected.
If a distribution is fit to log-transformed data (Log-Normal or Log-Pearson Type
III), the L-moment ratios for the log-transformed sample are used instead.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
select_ldistance(data)

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
\seealso{
\code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}, \code{\link[=select_lkurtosis]{select_lkurtosis()}}, \code{\link[=select_zstatistic]{select_zstatistic()}},
\code{\link[=plot_lmom_diagram]{plot_lmom_diagram()}}
}
