% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-spearman-test.R
\name{plot_spearman_test}
\alias{plot_spearman_test}
\title{Plot Spearman’s Rho Autocorrelation}
\usage{
plot_spearman_test(results, ...)
}
\arguments{
\item{results}{A list generated by \code{\link[=eda_spearman_test]{eda_spearman_test()}}.}

\item{...}{Optional named arguments: 'title', 'xlabel', and 'ylabel'.}
}
\value{
\code{ggplot}; a plot showing:
\itemize{
\item Vertical segments from \eqn{y=0} up to each \eqn{\rho} value at its lag.
\item Filled circles at each lag, filled black if serial correlation is detected.
}
}
\description{
Visualizes Spearman’s rho serial correlation coefficients with shaded points
indicating statistical significance.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
results <- eda_spearman_test(data)
plot_spearman_test(results)

}
