% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mle.R
\name{fit_mle}
\alias{fit_mle}
\title{Maximum Likelihood Parameter Estimation}
\usage{
fit_mle(data, distribution, ns_years = NULL, ns_structure = NULL)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
A list containing the results of parameter estimation:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{distribution}: The \code{distribution} argument.
\item \code{ns_years}: The \code{ns_years} argument, if given.
\item \code{ns_structure}: The \code{ns_structure} argument, if given.
\item \code{method}: \code{"MLE"}.
\item \code{params}: Numeric vector of estimated parameters.
\item \code{mll}: The maximum value of the log‐likelihood.
}
}
\description{
Estimates the parameters of a probability distribution by maximizing the log‐likelihood.
Initial parameter estimates are obtained using the method of L‐moments and optimization
is performed via \code{\link[stats:nlminb]{stats::nlminb()}} with repeated perturbations if needed.

\strong{For NS-FFA}: To estimate parameters for a nonstationary model, include the
observation years (\code{ns_years}) and the nonstationary model structure
(\code{ns_structure}).
}
\details{
\enumerate{
\item Calls \code{\link[=fit_lmoments]{fit_lmoments()}} on \code{data} to obtain initial parameter estimates.
\item Initializes trend parameters to zero if necessary.
\item For \code{WEI} models, sets the location parameter to zero to ensure support.
\item Defines an objective function using \code{\link[=utils_log_likelihood]{utils_log_likelihood()}}.
\item Runs \code{\link[stats:nlminb]{stats::nlminb()}} with box constraints. Attempts minimization up to 100 times.
}
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
ns_years <- seq(from = 1901, to = 2000)
ns_structure <- list(location = TRUE, scale = FALSE)
fit_mle(data, "GNO", ns_years, ns_structure)

}
\seealso{
\code{\link[=utils_log_likelihood]{utils_log_likelihood()}}, \code{\link[=fit_lmoments]{fit_lmoments()}}, \code{\link[stats:nlminb]{stats::nlminb()}}
}
