% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-screening.R
\name{data_screening}
\alias{data_screening}
\title{Perform Data Screening}
\usage{
data_screening(data, years)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}
}
\value{
A list with seven entries:
\itemize{
\item \code{years_min}: The minimum value in the 'years' argument.
\item \code{years_max}: The maximum value in the 'years' argument.
\item \code{data_min}: The minimum value in the 'data' argument.
\item \code{data_med}: The median value in the 'data' argument.
\item \code{data_max}: The maximum value in the 'data' argument.
\item \code{missing_years}: An integer vector of years with no data.
\item \code{missing_count}: The number of missing entries in the dataset.
}
}
\description{
Checks for missing entries and generates a list of summary statistics about a dataset.
}
\examples{
data <- rnorm(n = 10, mean = 100, sd = 10)
years <- c(1900, 1902, 1903, 1904, 1905, 1907, 1909, 1911, 1912, 1914)
data_screening(data, years)

}
