% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarEnvSim.r
\name{multivarEnvSim,GRaster,GRaster-method}
\alias{multivarEnvSim,GRaster,GRaster-method}
\alias{multivarEnvSim}
\alias{multivarEnvSim,GRaster,missing-method}
\alias{multivarEnvSim,data.frame,GRaster-method}
\alias{multivarEnvSim,data.table,GRaster-method}
\alias{multivarEnvSim,matrix,GRaster-method}
\title{Multivariate environmental similarity surface (MESS)}
\usage{
\S4method{multivarEnvSim}{GRaster,GRaster}(ref, proj)

\S4method{multivarEnvSim}{GRaster,missing}(ref, proj)

\S4method{multivarEnvSim}{data.frame,GRaster}(ref, proj, na.rm = FALSE)

\S4method{multivarEnvSim}{data.table,GRaster}(ref, proj, na.rm = FALSE)

\S4method{multivarEnvSim}{matrix,GRaster}(ref, proj, na.rm = FALSE)
}
\arguments{
\item{ref}{A \code{data.frame}, \code{data.table}, a points \code{GVector}, or "stack" of \code{GRasters}: This represents the set of "reference" environmental conditions:
\itemize{
\item \code{data.frame} or \code{data.table}: There must be one column per layer in \code{proj}, and the columns must have the same names as the layers in \code{proj}.
\item \code{GRaster} with one or more layers: Must have the same \code{\link[=names]{names()}} as the \code{GRaster}s in \code{proj}. Values are assumed to be continuous (not categorical/factors).
}}

\item{proj}{A \code{GRaster} or missing. If a \code{GRaster}, it must have the same layers as can have with one or more layers as \code{ref}. Values are assumed to be continuous (not categorical/factors). If missing, then \code{ref} is used, in which case the output represents the relative difference of each cell from the overall layer median.}

\item{na.rm}{Logical: If \code{FALSE} (default), and \code{ref} is a \code{data.frame}, \code{data.table}, or \code{matrix}, and has \code{NA}s in it, then the function will likely fail.}
}
\value{
A \code{GRaster} "stack". There will be one layer per layer in \code{ref}, indicating the MESS score for that variable. There will also be a layer named "MESS" which represents the MESS value across all variables (the minimum value of each of the individual MESS rasters). A final layer represents the layer which is most different (has the lowest MESS value).
}
\description{
The multivariate environmental similarity surface (MESS) indicates the degree to which a set of "projection" environmental conditions fall inside or outside a set of "reference" conditions. Values of 1 indicate a location falls at the exact median of all variables. Values of 0 indicate that the location has at least one environmental covariate that is at the upper or lower end of the range of reference conditions, and values <1 indicate that at least one variable falls above or below the reference conditions. MESS can be used, for example, to indicate the degree to which a model constructed in one time period and/or location must extrapolate when projected to another time period and/or location.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Climatic conditions with 4 variables
madChelsa <- fastData("madChelsa")
chelsa <- fast(madChelsa)

# Simulate new conditions by multiplying values by (1 + small number)
proj <- 1.05 * chelsa
names(proj) <- names(chelsa) # proj must have same names as ref

messes <- multivarEnvSim(ref = chelsa, proj = proj)
plot(messes)

# Where is at least one variable outside the reference range?
extrap <- messes[["MESS"]] < 0
levs <- data.frame(value = 0:1, labels = c('no extrapolation', 'extrapolation'))
levels(extrap) <- levs
plot(extrap)

# Using a data frame as "reference" conditions:
madDypsis <- fastData("madDypsis") # Dypsis occurrences
dypsis <- fast(madDypsis)

dypEnv <- extract(chelsa, dypsis)
dypMess <- multivarEnvSim(ref = dypEnv, proj = proj)
plot(dypMess)

}
}
\references{
Elith, J, Kearney, M, and Phillips, S. 2010. The art of modelling range-shifting species. \emph{Methods in Ecology and Evolution} 1:330-342. \doi{10.1111/j.2041-210X.2010.00036.x} (see especially the Supplement)
}
