% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_parity.R
\name{roc_parity}
\alias{roc_parity}
\title{ROC AUC parity}
\usage{
roc_parity(data, outcome, group, probs, base = NULL, group_breaks = NULL)
}
\arguments{
\item{data}{Data.frame that contains the necessary columns.}

\item{outcome}{Column name indicating the binary outcome variable (character).}

\item{group}{Column name indicating the sensitive group (character).}

\item{probs}{Column name or vector with the predicted probabilities (numeric between 0 - 1).}

\item{base}{Base level of the sensitive group (character).}

\item{group_breaks}{If group is continuous (e.g., age): either a numeric vector of two or more unique cut points or a single number >= 2 giving the number of intervals into which group feature is to be cut.}
}
\value{
\item{Metric}{Raw ROC AUC metrics for all groups and metrics standardized for the base group (parity metric). Lower values compared to the reference group mean lower ROC AUC values in the selected subgroups}
\item{Metric_plot}{Bar plot of ROC AUC metric}
\item{Probability_plot}{Density plot of predicted probabilities per subgroup}
\item{ROCAUC_plot}{ROC plots for all subgroups}
}
\description{
This function computes the ROC AUC parity metric
}
\details{
This function computes the ROC AUC values for each subgroup. In the returned table,
the reference group will be assigned 1, while all other groups will be assigned values
according to whether their ROC AUC values are lower or higher compared to the reference group. Lower
ROC AUC will be reflected in numbers lower than 1 in the returned named vector, thus numbers
lower than 1 mean WORSE prediction for the subgroup.
}
\examples{
data(compas)
compas$Two_yr_Recidivism_01 <- ifelse(compas$Two_yr_Recidivism == 'yes', 1, 0) 
roc_parity(data = compas, outcome = 'Two_yr_Recidivism_01', group = 'ethnicity',
probs = 'probability', base = 'Caucasian')
roc_parity(data = compas, outcome = 'Two_yr_Recidivism_01', group = 'ethnicity',
probs = 'probability', base = 'African_American')

}
