% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-egarch-spec.R
\name{egarch_type_spec}
\alias{egarch_type_spec}
\alias{loggarch_type_spec}
\title{Subspecification of EGARCH Family Models}
\usage{
egarch_type_spec(
  orders = c(1, 1),
  long_memo = TRUE,
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald"),
  powers = c(1, 1),
  modulus = c(FALSE, FALSE)
)

loggarch_type_spec(
  orders = c(1, 1),
  long_memo = TRUE,
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)
}
\arguments{
\item{orders}{a two-element numeric vector with the model
orders; the first element is the order \eqn{p} for the term based on
\eqn{\ln\left(\sigma_t^2\right)}, i.e. the log-transformed
conditional variance, while the second element is the order \eqn{q} for
the innovation-based term (see Details below for more information).}

\item{long_memo}{a logical value that indicates whether the
long-memory version of the model should be considered or not.}

\item{cond_dist}{a character value stating the underlying
conditional distribution to consider; available are a normal
distribution (\code{"norm"}), a \eqn{t}-distribution
(\code{"std"}), a generalized error distribution
(\code{"ged"}), an average Laplace distribution (\code{"ald"})
and the skewed versions of them
(\code{"snorm"}, \code{"sstd"}, \code{"sged"}, \code{"sald"}).}

\item{powers}{a two-element numeric vector that states the
exponents in the power-transformations of the asymmetry and the
magnitude terms in that order (see Details for more information).}

\item{modulus}{a two-element logical vector indicating if the
innovations in the asymmetry and the magnitude terms (in that
order) should use a modulus transformation (see Details for
more information).}
}
\value{
An object of class \code{"egarch_type_spec"} or
\code{"loggarch_type_spec"} is returned.
}
\description{
Two common subspecifications of the broad EGARCH family,
namely for a EGARCH-type and a Log-GARCH-type model.
}
\details{
These are wrappers for \code{\link{fEGarch_spec}}.
\code{egarch_type_spec()} is when setting \code{model_type} in
\code{\link{fEGarch_spec}} to \code{eGARCH}.
\code{loggarch_type_spec()} is a shortcut when setting
\code{model_type = "loggarch"}. See \code{\link{fEGarch_spec}}
for further details.
}
