% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{var_lab}
\alias{var_lab}
\alias{var_lab<-}
\alias{set_var_lab}
\alias{unvr}
\alias{drop_var_labs}
\alias{add_labelled_class}
\title{Set or get variable label}
\usage{
var_lab(x, default = NULL)

var_lab(x) <- value

set_var_lab(x, value)

unvr(x)

drop_var_labs(x)

add_labelled_class(
  x,
  remove_classes = c("haven_labelled", "spss_labelled", "haven_labelled_spss",
    "vctrs_vctr")
)
}
\arguments{
\item{x}{Variable. In the most cases it is numeric vector.}

\item{default}{A character scalar. What we want to get from 'var_lab' if
there is no variable label. NULL by default.}

\item{value}{A character scalar - label for the variable x.}

\item{remove_classes}{A character vector of classes which should be removed
from the class attribute of the \code{x}.}
}
\value{
\code{var_lab} return variable label. If label doesn't exist it return
  NULL . \code{var_lab<-} and \code{set_var_lab} return variable (vector x)
  of class "labelled" with attribute "label" which equals submitted value.
}
\description{
These functions set/get/drop variable labels. For 
value labels see \link{val_lab}. For working with entire data.frame see
\link{apply_labels}.
\itemize{
\item{\code{var_lab}}{ returns variable label or NULL if label doesn't 
exist.} 
\item{\code{var_lab<-}}{ set variable label.} 
\item{\code{set_var_lab}}{ returns variable with label.}
\item{\code{unvr}}{ drops variable label.} 
\item{\code{add_labelled_class}}{ Add missing 'labelled' class. This function
is needed when you load SPSS data with packages which in some cases don't set
'labelled' class for variables with labels. For example, \code{haven} package
doesn't set 'labelled' class for variables which have variable label but
don't have value labels. Note that to use 'expss' with 'haven' you need to
load 'expss' strictly after 'haven' to avoid conflicts.} }
}
\details{
Variable label is stored in attribute "label" (\code{attr(x,"label")}). For
  preserving from dropping this attribute during some operations (such as \code{c})
  variable class is set to "labelled". There are special methods of
  subsetting and concatenation for this class. To drop variable label use 
  \code{var_lab(var) <- NULL} or \code{unvr(var)}.
}
\examples{
data(mtcars)
var_lab(mtcars$mpg) = "Miles/(US) gallon"
var_lab(mtcars$cyl) = "Number of cylinders"
var_lab(mtcars$disp) = "Displacement (cu.in.)"
var_lab(mtcars$hp) = "Gross horsepower"
var_lab(mtcars$drat) = "Rear axle ratio"
var_lab(mtcars$wt) = "Weight (lb/1000)"
var_lab(mtcars$qsec) = "1/4 mile time"
var_lab(mtcars$vs) = "V/S"
var_lab(mtcars$am) = "Transmission (0 = automatic, 1 = manual)"
val_lab(mtcars$am) = c(automatic = 0, manual=1)
var_lab(mtcars$gear) = "Number of forward gears"
var_lab(mtcars$carb) = "Number of carburetors"

fre(mtcars$am)

cross_mean(mtcars, list(mpg, disp, hp, qsec), list(total(), am))
 
\dontrun{
if(FALSE){ # to prevent execution
# you need to load packages strictly in this order to avoid conflicts
library(haven)
library(expss)
spss_data = haven::read_spss("spss_file.sav")
# add missing 'labelled' class
spss_data = add_labelled_class(spss_data) 
}
}
}
