#' @name POWOcodes
#'
#' @docType data
#'
#' @title Complete list of vascular plant families and associated URI addresses
#'
#' @description Complete list of the vascular plants (APG IV-based families of
#' flowering plants, gymnosperm and pteridophytes) and associated URI addresses
#' as retrieved with the function \code{get_pow} of the package
#' [taxize](https://docs.ropensci.org/taxize/index.html).
#'
#' @format \code{data.frame}
#'
#' @usage data(POWOcodes)

NULL

#' @name botregions
#'
#' @docType data
#'
#' @title Countries and associated classification of botanical divisions
#'
#' @description Countries and associated classification of botanical divisions
#' according to the World Geographical Scheme for Recording Plant Distributions.
#'
#' @format \code{data.frame}
#'
#' @source <https://www.tdwg.org/standards/wgsrpd/>
#'
#' @usage data(botregions)

NULL

#' @name angioData
#'
#' @docType data
#'
#' @title List of Angiosperm species
#'
#' @description Complete list of all non-hybrid species and
#' associated data of Lecythidaceae, Aristolochiaceae, Martyniaceae,
#' Cabombaceae, and Begoniaceae, as retrieved from POWO database in November 2022
#' using the \code{expowo}'s function \code{powoSpecies}.
#'
#' @format \code{data.frame}
#'
#' @usage data(angioData)

NULL

#' @name angioGenera
#'
#' @docType data
#'
#' @title List of Angiosperm genera
#'
#' @description Complete list of all genera and associated data of
#' Lecythidaceae, Aristolochiaceae, Begoniaceae, Martyniaceae, Dipterocarpaceae,
#' and Fagaceae, as retrieved from POWO database in January 2023 using the
#' \code{expowo}'s function \code{powoGenera}.
#'
#' @format \code{data.frame}
#'
#' @usage data(angioGenera)

NULL
