% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mrand}
\alias{mrand}
\title{Adjusted Rand Index}
\usage{
mrand(N)
}
\arguments{
\item{N}{Confusion matrix.}
}
\value{
\item{mri}{Adjusted Rand Index of a confusion matrix (scalar).}
}
\description{
Performs the Adjusted Rand Index on a confusion matrix (row-by-column product of two partition-matrices). ARI is a measure of the similarity between two data clusterings.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

# standardizing the data
iris <- scale(iris)

# double k-means with 3 unit-clusters and 2 components for the variables
p1 <- redkm(iris, K = 3, Q = 2, Rndstart = 10)
p2 <- doublekm(iris, K=3, Q=2, Rndstart = 10)
mri <- mrand(t(p1$U)\%*\%p2$U)
}
\references{
Rand W. M. (1971) "Objective criteria for the evaluation of clustering methods" <doi:10.2307/2284239>
}
\author{
Ionel Prunila, Maurizio Vichi
}
