% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{G.cd}
\alias{G.cd}
\title{Family of continuous/discrete instrumental function}
\usage{
G.cd(
  x,
  g.idx,
  data,
  n.if.per.cov,
  idxs.c,
  G.c,
  norm.func,
  discrete.covariate.levels = NULL,
  cov.ranges = NULL,
  norm.cov.out = NULL,
  degree = 3
)
}
\arguments{
\item{x}{The vector of covariates at which to evaluate the B-splines}

\item{g.idx}{The index of the instrumental function.}

\item{data}{Data frame containing the data.}

\item{n.if.per.cov}{Number of instrumental functions per continuous covariate.}

\item{idxs.c}{Vector of indices of the continuous elements in the vector of
covariates.}

\item{G.c}{Family of instrumental functions to use for the subvector of
continuous covariates.}

\item{norm.func}{Function to be used to normalize the covariates.}

\item{discrete.covariate.levels}{Matrix containing as rows all possible
'combined' levels of the discrete covariates. Default is
\code{discrete.covariate.levels = NULL}.}

\item{cov.ranges}{Matrix containing as its rows the lower and upper bounds
for each continuous covariate. Default is \code{cov.ranges = NULL}.}

\item{norm.cov.out}{Output of a preliminary call to a covariate normalization
function (defined above). This is used to speed up computations. Note that
this argument should only apply to continuous covariates!! Default is
\code{norm.cov.out = NULL}.}

\item{degree}{Degree of the spline functions to be used as instrumental
functions for the continuous covariates (if applicable). Default is
\code{degree = 3}.}
}
\description{
The function normalizes the continuous covariates to lie in the
unit interval and then evaluates the subvector of continuous covariates on
the specified family of instrumental function. For the discrete elements,
indicator functions are used for each level.
}
