% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconcile.R
\name{compare_rows_with_same_index}
\alias{compare_rows_with_same_index}
\title{Identifies and summarizes value-level changes between two datasets}
\usage{
compare_rows_with_same_index(new_df, old_df)
}
\arguments{
\item{new_df}{A data frame containing the most recent version of the data.}

\item{old_df}{A data frame containing the preceding version of the data,
used as the reference for comparison.}
}
\value{
A data frame augmented with two additional columns:
  `changed_cols` and `change_details`
}
\description{
This function compares corresponding rows of two data frames and generates
two columns:
}
\details{
* **changed_cols** — a list-column containing the names of variables in which
  at least one change has been detected.
* **change_details** — a list-column describing the specific modifications for
  each changed variable, expressed as "previous value - new value".
}
\author{
Lukasz Andrzejewski
}
